#!/usr/bin/env sh
# This script converts the mnist data into lmdb/leveldb format,
# depending on the value assigned to $BACKEND.

EXAMPLE=examples/mnist
DATA=$EXAMPLE/data
BUILD=build/examples/mnist

path=$EXAMPLE/data

echo "Creating mnist..."

mkdir -p ${path}/mnist_train
mkdir -p ${path}/mnist_test

$BUILD/convert_mnist_to_images.bin $DATA/train-images-idx3-ubyte \
  $DATA/train-labels-idx1-ubyte --path=$path/mnist_train
$BUILD/convert_mnist_to_images.bin $DATA/t10k-images-idx3-ubyte \
  $DATA/t10k-labels-idx1-ubyte --path=$path/mnist_test

##

BACKEND="lmdb"

echo "Creating ${BACKEND}..."

rm -rf $EXAMPLE/mnist_train_${BACKEND}
rm -rf $EXAMPLE/mnist_test_${BACKEND}

$BUILD/convert_mnist_data.bin $DATA/train-images-idx3-ubyte \
  $DATA/train-labels-idx1-ubyte $path/mnist_train_${BACKEND} --backend=${BACKEND}
$BUILD/convert_mnist_data.bin $DATA/t10k-images-idx3-ubyte \
  $DATA/t10k-labels-idx1-ubyte $path/mnist_test_${BACKEND} --backend=${BACKEND}


echo "Done."
