#!/usr/bin/env sh
# Create the face lmdb inputs
# N.B. set the path to the face train + val data dirs

EXAMPLE=examples/face
DATA=$EXAMPLE/data
BUILD=build/examples/face

TRAIN_DATA_ROOT=$DATA/face_images_train/
VAL_DATA_ROOT=$DATA/face_images_test/

skip_freq=1 # sample one image per $skip_freq images
data_size=$(( 12000 / skip_freq ))
echo $data_size

# Set RESIZE=true to resize the images to 28x28. Leave as false if images have
# already been resized using another tool.
RESIZE=false
if $RESIZE; then
  RESIZE_HEIGHT=28
  RESIZE_WIDTH=28
else
  RESIZE_HEIGHT=0
  RESIZE_WIDTH=0
fi

if [ ! -d "$TRAIN_DATA_ROOT" ]; then
  echo "Error: TRAIN_DATA_ROOT is not a path to a directory: $TRAIN_DATA_ROOT"
  echo "Set the TRAIN_DATA_ROOT variable in create_face.sh to the path" \
       "where the Olivetti Face training data is stored."
  exit 1
fi

if [ ! -d "$VAL_DATA_ROOT" ]; then
  echo "Error: VAL_DATA_ROOT is not a path to a directory: $VAL_DATA_ROOT"
  echo "Set the VAL_DATA_ROOT variable in create_face.sh to the path" \
       "where the Olivetti Face validation data is stored."
  exit 1
fi

echo "Creating train lmdb..."

GLOG_logtostderr=1 $BUILD/convert_face_data.bin \
    --resize_height=$RESIZE_HEIGHT \
    --resize_width=$RESIZE_WIDTH \
    --gray \
    --shuffle \
    --skip_freq $skip_freq \
    $TRAIN_DATA_ROOT \
    $TRAIN_DATA_ROOT/train_list.txt \
    $DATA/face_train_lmdb

echo "Creating val lmdb..."

GLOG_logtostderr=1 $BUILD/convert_face_data.bin \
    --resize_height=$RESIZE_HEIGHT \
    --resize_width=$RESIZE_WIDTH \
    --gray \
    --shuffle \
    --skip_freq $skip_freq \
    $VAL_DATA_ROOT \
    $VAL_DATA_ROOT/test_list.txt \
    $DATA/face_val_lmdb

echo "Creating mean image..."

GLOG_logtostderr=1 ./build/tools/compute_image_mean -backend="lmdb" \
  $DATA/face_train_lmdb $DATA/mean.binaryproto

echo "Done."
