#!/usr/bin/env sh
# Create the kin40k lmdb inputs
# N.B. set the path to the kin40k train + val data dirs

EXAMPLE=examples/kin40k
BUILD=build/examples/kin40k

echo "Creating kin40k.tab..."
matlab -nodisplay -nojvm -nosplash -nodesktop -r \
      "try, run('${EXAMPLE}/data/convert_mat_to_tab.m'), catch, exit(1), end, exit(0);"
echo "matlab exit code: $?"

echo "Creating kin40k lmdb..."
GLOG_logtostderr=1 $BUILD/convert_data.bin \
    --data=$EXAMPLE/data/kin40k.tab \
    --test_ratio=0.1 \
    -dim=8 \
    --shuffle \
    $EXAMPLE/data/kin40k_train_lmdb \
    $EXAMPLE/data/kin40k_val_lmdb

echo "Done."
