//
//  CVXGenRangeSolver25x25+TestSolver.m
//  CVXSolver
//
/* Produced by CVXGEN, 2012-11-27 15:57:37 -0800.  */
/* CVXGEN is Copyright (C) 2006-2011 Jacob Mattingley, jem@cvxgen.com. */
/* The code in this file is Copyright (C) 2006-2011 Jacob Mattingley. */
/* CVXGEN, or solvers produced by CVXGEN, cannot be used for commercial */
/* applications without prior written permission from Jacob Mattingley. */

//  Translated to Objective-C and minor modifications
//  by Daniel Graf in November 2012.

#import "CVXGenRangeSolver25x25+TestSolver.h"
#import "CVXGenRangeSolver25x25+Util.h"
@implementation CVXGenRangeSolver25x25 (TestSolver)

-(double *) test_solver {
   int num_iters;
#if (NUMTESTS > 0)
   int i;
   double time;
   double time_per;
#endif
   [self set_defaults];
   [self setup_indexing];
   [self load_testcase];
   // load_default_data();
   
   /* Solve problem instance for the record. */
   settings.verbose = 1;
   [self tic];
   num_iters = (int)[self solve];
   float solvetime = [self toc];
   printf("solvetime %f in %d iterations\n",solvetime,num_iters);
   printf("solution:\nx = ");
    //original testcase
    // double xsol[50] = {6.144000,6.144000,6.144000,6.144000,6.144000,6.144011,6.920703,8.995584,12.429028,17.121533,23.098660,29.230385,32.457869,33.635850,34.015579,34.060750,34.062309,33.893009,33.449832,32.507625,29.868296,24.921008,20.659031,17.671499,16.137438,29.208927,28.831980,28.006110,26.526467,24.790563,23.901019,23.412183,23.041086,22.791805,22.611963,22.636808,22.663199,22.688869,22.630897,22.552194,22.560963,22.733950,23.215561,24.550871,27.451077,31.775493,36.563301,39.931035,42.004179,42.919502};
    //testcase aus meiner app
    double xsol[50] = {11.274718,11.274718,11.274718,11.274718,11.274718,11.274718,11.274718,11.274718,17.402120,20.772761,25.803858,29.533497,30.538190,28.674026,26.126434,26.438275,27.139129,27.183993,27.253313,30.131779,28.700357,25.085931,21.967880,16.892248,12.158462,22.730457,22.671262,23.034850,24.397143,24.126196,27.330589,29.241338,25.857728,24.272230,25.828397,33.155695,31.592190,32.352852,31.739391,32.227475,28.819433,25.303434,22.629574,20.855340,20.247181,21.377884,31.863258,33.306716,33.306716,31.732671};
   double AbsSumError = 0;
   double L2Error = 0;
   double L2RelError = 0;
   double SL2norm = 0;
   int is;
   for(is=0;is<50;is++) {
       printf("%c%lf",(is==0)?'{':',',vars.st[is]);
       AbsSumError += fabs(vars.st[is]-xsol[is]);
       L2Error += (vars.st[is]-xsol[is])*(vars.st[is]-xsol[is]);
       SL2norm += vars.st[is] * vars.st[is];
   }
   printf("};\n");
   printf("absolute summed error  %.8lf\n",AbsSumError);
   SL2norm = sqrt(SL2norm);
   L2Error = sqrt(L2Error);
   L2RelError = L2Error/SL2norm;
   printf("L2 error               %.8lf\n",L2Error);
   printf("L2 relative error      %.8lf\n",L2RelError);
   
   
#ifndef ZERO_LIBRARY_MODE
#if (NUMTESTS > 0)
   /* Now solve multiple problem instances for timing purposes. */
   settings.verbose = 0;
   
   tic();
   for (i = 0; i < NUMTESTS; i++) {
       solve();
   }
   time = tocq();
   
   printf("Timed %d solves over %.3f seconds.\n", NUMTESTS, time);
   time_per = time / NUMTESTS;
   
   if (time_per > 1) {
       printf("Actual time taken per solve: %.3g s.\n", time_per);
   } else if (time_per > 1e-3) {
       printf("Actual time taken per solve: %.3g ms.\n", 1e3*time_per);
   } else {
       printf("Actual time taken per solve: %.3g us.\n", 1e6*time_per);
   }
#endif
#endif
   
    return vars.st;
}


-(void) load_testcase {
  //problem specification:

double W = 512.000000;
double H = 680.000000;
double LW = 6.144000;
double LH = 4.080000;
// double B[50] = {-0.000010,-0.000010,-0.000010,-0.000010,-0.000010,-0.000010,-0.000010,-0.000010,-0.000012,-0.000015,-0.000053,-0.000303,-0.000587,-0.000700,-0.000747,-0.000744,-0.000734,-0.000724,-0.000672,-0.000595,-0.000303,-0.000044,-0.000017,-0.000012,-0.000010,-0.000053,-0.000051,-0.000054,-0.000103,-0.000285,-0.000416,-0.000509,-0.000594,-0.000656,-0.000692,-0.000696,-0.000687,-0.000671,-0.000689,-0.000715,-0.000718,-0.000694,-0.000616,-0.000365,-0.000166,-0.000068,-0.000016,-0.000014,-0.000014,-0.000016};
double B[50] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

// aus Sir -> hat andere Matrixerzeugungsprozedur
// double S[2500] = {0.257273,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.250000,0.507273,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,-0.250000,0.507273,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,-0.250000,0.507273,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,-0.250000,0.507273,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,-0.250000,0.507273,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.507273,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.507273,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.509441,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000520,-0.000820,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000801,-0.002876,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.511370,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000554,-0.001327,-0.000919,-0.000759,-0.000438,-0.000438,-0.000438,-0.001140,-0.004100,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.539890,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000724,-0.002471,-0.001912,-0.003091,-0.004832,-0.001480,-0.000438,-0.000438,-0.003458,-0.002129,-0.003024,-0.003994,-0.004706,-0.005759,-0.006475,-0.005887,-0.003932,-0.001921,-0.000769,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.729178,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.004788,-0.004147,-0.005296,-0.003659,-0.002929,-0.003610,-0.000802,-0.003535,-0.012814,-0.019878,-0.028811,-0.033084,-0.035430,-0.039384,-0.042009,-0.040130,-0.032806,-0.018928,-0.009271,-0.001608,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.944033,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.006086,-0.006514,-0.002970,-0.004678,-0.010631,-0.007113,-0.012211,-0.028069,-0.046314,-0.054345,-0.056068,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056045,-0.051511,-0.032215,-0.009957,-0.001800,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.029552,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.002457,-0.005393,-0.007456,-0.004103,-0.010663,-0.030213,-0.048865,-0.055745,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.044838,-0.020263,-0.004486,-0.000438,-0.000438,-0.000438,-0.000890,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.065498,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.002477,-0.000636,-0.000912,-0.008300,-0.033793,-0.055329,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.044613,-0.021170,-0.009446,-0.000675,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.062554,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.001808,-0.014729,-0.048247,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.053083,-0.035305,-0.012460,-0.005527,-0.000885,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.055412,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.002037,-0.015170,-0.048570,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.049180,-0.017617,-0.018001,-0.009962,-0.000752,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.047968,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.001193,-0.008823,-0.033432,-0.055117,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.054414,-0.027601,-0.017010,-0.008125,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.008696,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000718,-0.000438,-0.000440,-0.002288,-0.010932,-0.032803,-0.053792,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.055192,-0.030563,-0.012699,-0.003662,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.949853,-0.250000,0.000000,0.000000,0.000000,0.000000,-0.006074,-0.002551,-0.002543,-0.001662,-0.002127,-0.009156,-0.029406,-0.052218,-0.056068,-0.056074,-0.056074,-0.055522,-0.050988,-0.054231,-0.056074,-0.056074,-0.055966,-0.046689,-0.020511,-0.004214,-0.000438,-0.000458,-0.000438,-0.000438,-0.001420,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.729156,-0.250000,0.000000,0.000000,0.000000,-0.004647,-0.003833,-0.003206,-0.003573,-0.002205,-0.001881,-0.007261,-0.018100,-0.031619,-0.038544,-0.036492,-0.025426,-0.016850,-0.021454,-0.033770,-0.038106,-0.030816,-0.016088,-0.006408,-0.001625,-0.001310,-0.000548,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.533341,-0.250000,0.000000,0.000000,-0.002695,-0.001904,-0.003103,-0.001340,-0.001117,-0.000438,-0.001463,-0.001378,-0.003097,-0.004418,-0.004109,-0.003555,-0.001836,-0.002366,-0.004088,-0.005143,-0.003532,-0.001516,-0.000480,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.512654,-0.250000,0.000000,-0.002373,-0.002550,-0.001577,-0.000500,-0.000438,-0.000438,-0.001183,-0.002548,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.509262,-0.250000,-0.000585,-0.001233,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.002491,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.257565,-0.000730,-0.000586,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000520,-0.000438,-0.000724,-0.004788,-0.006086,-0.002457,-0.002477,-0.000438,-0.000438,-0.000438,-0.000718,-0.006074,-0.004647,-0.002695,-0.002373,-0.000585,-0.000730,0.310433,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000820,-0.000554,-0.002471,-0.004147,-0.006514,-0.005393,-0.000636,-0.000438,-0.000438,-0.000438,-0.000438,-0.002551,-0.003833,-0.001904,-0.002550,-0.001233,-0.000586,-0.250000,0.557901,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.001327,-0.001912,-0.005296,-0.002970,-0.007456,-0.000912,-0.001808,-0.002037,-0.001193,-0.000440,-0.002543,-0.003206,-0.003103,-0.001577,-0.000438,-0.000438,0.000000,-0.250000,0.561137,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000919,-0.003091,-0.003659,-0.004678,-0.004103,-0.008300,-0.014729,-0.015170,-0.008823,-0.002288,-0.001662,-0.003573,-0.001340,-0.000500,-0.000438,-0.000438,0.000000,0.000000,-0.250000,0.616939,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000759,-0.004832,-0.002929,-0.010631,-0.010663,-0.033793,-0.048247,-0.048570,-0.033432,-0.010932,-0.002127,-0.002205,-0.001117,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,-0.250000,0.824513,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.001480,-0.003610,-0.007113,-0.030213,-0.055329,-0.056074,-0.056074,-0.055117,-0.032803,-0.009156,-0.001881,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,-0.250000,0.974338,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000802,-0.012211,-0.048865,-0.056074,-0.056074,-0.056074,-0.056074,-0.053792,-0.029406,-0.007261,-0.001463,-0.001183,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.079738,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.003535,-0.028069,-0.055745,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.052218,-0.018100,-0.001378,-0.002548,-0.002491,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.177225,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000801,-0.001140,-0.003458,-0.012814,-0.046314,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056068,-0.031619,-0.003097,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.247797,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.002876,-0.004100,-0.002129,-0.019878,-0.054345,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.038544,-0.004418,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.288538,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.003024,-0.028811,-0.056068,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.036492,-0.004109,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.293193,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.003994,-0.033084,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.055522,-0.025426,-0.003555,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.282767,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.004706,-0.035430,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.050988,-0.016850,-0.001836,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.265040,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.005759,-0.039384,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.054231,-0.021454,-0.002366,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.285195,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.006475,-0.042009,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.033770,-0.004088,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.314143,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.005887,-0.040130,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.038106,-0.005143,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.318547,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.003932,-0.032806,-0.056045,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.056074,-0.055966,-0.030816,-0.003532,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.290960,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.001921,-0.018928,-0.051511,-0.056074,-0.056074,-0.053083,-0.049180,-0.054414,-0.055192,-0.046689,-0.016088,-0.001516,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,1.202302,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000769,-0.009271,-0.032215,-0.044838,-0.044613,-0.035305,-0.017617,-0.027601,-0.030563,-0.020511,-0.006408,-0.000480,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.915455,-0.250000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.001608,-0.009957,-0.020263,-0.021170,-0.012460,-0.018001,-0.017010,-0.012699,-0.004214,-0.001625,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.689110,-0.250000,0.000000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.001800,-0.004486,-0.009446,-0.005527,-0.009962,-0.008125,-0.003662,-0.000438,-0.001310,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.577953,-0.250000,0.000000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000675,-0.000885,-0.000752,-0.000438,-0.000438,-0.000458,-0.000548,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.518190,-0.250000,0.000000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.516493,-0.250000,0.000000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.516493,-0.250000,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.000890,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,-0.001420,-0.000438,-0.000438,-0.000438,-0.000438,-0.000438,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.250000,0.268651};

// aus meiner App -> mit Erzeugung gemäss Paper
double S[2500] = {0.029802,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.029802,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.029802,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.029802,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.029802,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.029802,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.029802,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.029802,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.038685,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.002129,-0.003359,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003284,-0.011784,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.046591,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.002271,-0.005437,-0.003765,-0.003109,-0.001795,-0.001795,-0.001795,-0.004670,-0.016801,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.070560,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.002966,-0.010127,-0.007834,-0.012667,-0.019799,-0.006067,-0.001795,-0.001795,-0.012912,-0.002757,-0.001795,-0.002232,-0.001875,-0.001795,-0.001795,-0.001886,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.119004,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.019621,-0.016992,-0.021703,-0.014993,-0.012002,-0.014794,-0.001795,-0.001795,-0.012545,-0.002494,-0.002044,-0.002438,-0.001795,-0.001795,-0.002202,-0.003557,-0.006994,-0.011446,-0.016103,-0.003120,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.176192,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.024941,-0.026691,-0.012171,-0.019169,-0.041286,-0.014253,-0.001879,-0.002714,-0.008656,-0.001795,-0.001795,-0.002296,-0.002385,-0.002220,-0.001795,-0.001795,-0.001795,-0.017467,-0.044924,-0.021238,-0.006878,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.145896,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.010068,-0.022100,-0.030535,-0.009958,-0.003013,-0.001975,-0.002208,-0.001795,-0.006718,-0.001795,-0.001795,-0.001795,-0.001795,-0.003150,-0.001795,-0.001795,-0.001795,-0.009099,-0.041046,-0.040561,-0.015880,-0.001795,-0.001795,-0.001795,-0.003646,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.103862,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.010151,-0.002606,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.004179,-0.001795,-0.001795,-0.001795,-0.001795,-0.003549,-0.001952,-0.001795,-0.001795,-0.002685,-0.024375,-0.042195,-0.035018,-0.002767,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.105146,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.004994,-0.014915,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003104,-0.048937,-0.028833,-0.021616,-0.003627,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.124385,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003858,-0.009123,-0.001795,-0.001959,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.022122,-0.009696,-0.066133,-0.040820,-0.003081,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.129136,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001961,-0.001795,-0.001795,-0.005952,-0.031240,-0.029254,-0.058654,-0.033294,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.110369,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.002942,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.002691,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003842,-0.025414,-0.018210,-0.030803,-0.036776,-0.015006,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.125106,0.000000,0.000000,0.000000,0.000000,0.000000,-0.024889,-0.010452,-0.010421,-0.006801,-0.004478,-0.003551,-0.005304,-0.008259,-0.006043,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001952,-0.013517,-0.019133,-0.021685,-0.021593,-0.008261,-0.001795,-0.001877,-0.001795,-0.001795,-0.005817,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.101217,0.000000,0.000000,0.000000,0.000000,-0.019044,-0.015706,-0.013136,-0.014639,-0.009034,-0.004490,-0.006822,-0.005955,-0.001795,-0.001795,-0.001878,-0.001795,-0.001795,-0.001977,-0.004011,-0.005232,-0.007112,-0.007655,-0.009774,-0.005776,-0.005370,-0.002244,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.061105,0.000000,0.000000,0.000000,-0.011043,-0.007803,-0.012714,-0.005489,-0.004577,-0.001795,-0.005716,-0.001795,-0.001795,-0.001795,-0.001795,-0.005644,-0.004005,-0.003033,-0.002443,-0.003898,-0.002314,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.051853,0.000000,0.000000,-0.009723,-0.010451,-0.006464,-0.002051,-0.001795,-0.001795,-0.004849,-0.010440,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.037952,0.000000,-0.002397,-0.005054,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.010207,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.030998,-0.002989,-0.002401,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.002129,-0.001795,-0.002966,-0.019621,-0.024941,-0.010068,-0.010151,-0.001795,-0.001795,-0.001795,-0.002942,-0.024889,-0.019044,-0.011043,-0.009723,-0.002397,-0.002989,0.247634,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003359,-0.002271,-0.010127,-0.016992,-0.026691,-0.022100,-0.002606,-0.001795,-0.001795,-0.001795,-0.001795,-0.010452,-0.015706,-0.007803,-0.010451,-0.005054,-0.002401,0.000000,0.237259,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.005437,-0.007834,-0.021703,-0.012171,-0.030535,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.010421,-0.013136,-0.012714,-0.006464,-0.001795,-0.001795,0.000000,0.000000,0.224583,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003765,-0.012667,-0.014993,-0.019169,-0.009958,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.006801,-0.014639,-0.005489,-0.002051,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.178079,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003109,-0.019799,-0.012002,-0.041286,-0.003013,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.004478,-0.009034,-0.004577,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.192475,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.006067,-0.014794,-0.014253,-0.001975,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003551,-0.004490,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.119322,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001879,-0.002208,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.005304,-0.006822,-0.005716,-0.004849,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.091687,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.002714,-0.001795,-0.001795,-0.004994,-0.003858,-0.001795,-0.001795,-0.008259,-0.005955,-0.001795,-0.010440,-0.010207,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.118573,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003284,-0.004670,-0.012912,-0.012545,-0.008656,-0.006718,-0.004179,-0.014915,-0.009123,-0.001795,-0.002691,-0.006043,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.166955,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.011784,-0.016801,-0.002757,-0.002494,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.107722,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.002044,-0.001795,-0.001795,-0.001795,-0.001795,-0.001959,-0.001795,-0.001795,-0.001795,-0.001878,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.068328,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.002232,-0.002438,-0.002296,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.005644,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.075759,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001875,-0.001795,-0.002385,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.004005,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.071919,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.002220,-0.003150,-0.003549,-0.001795,-0.001795,-0.001961,-0.001795,-0.001795,-0.001977,-0.003033,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.075292,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.002202,-0.001795,-0.001795,-0.001952,-0.001795,-0.001795,-0.001795,-0.001795,-0.001952,-0.004011,-0.002443,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.072981,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001886,-0.003557,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003842,-0.013517,-0.005232,-0.003898,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.099449,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.006994,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.005952,-0.025414,-0.019133,-0.007112,-0.002314,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.152136,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.011446,-0.017467,-0.009099,-0.002685,-0.003104,-0.022122,-0.031240,-0.018210,-0.021685,-0.007655,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.258472,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.016103,-0.044924,-0.041046,-0.024375,-0.048937,-0.009696,-0.029254,-0.030803,-0.021593,-0.009774,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.456934,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003120,-0.021238,-0.040561,-0.042195,-0.028833,-0.066133,-0.058654,-0.036776,-0.008261,-0.005776,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.509700,0.000000,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.006878,-0.015880,-0.035018,-0.021616,-0.040820,-0.033294,-0.015006,-0.001795,-0.005370,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.307800,0.000000,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.002767,-0.003627,-0.003081,-0.001795,-0.001795,-0.001877,-0.002244,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.074538,0.000000,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.067582,0.000000,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.067582,0.000000,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.003646,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,-0.005817,-0.001795,-0.001795,-0.001795,-0.001795,-0.001795,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.000000,0.076426};

//end of problem specification
  int ii;
  for(ii=0;ii<2500;ii++) params.E[ii] = S[ii];
  for(ii=0;ii<50;ii++) params.B[ii] = B[ii];
  for(ii=0;ii<25;ii++) {
    params.minW[ii] = LW;
    params.minH[ii] = LH;
    params.maxW[ii] = W;
    params.maxH[ii] = H;
  }
  params.imageWidth[0] = W;
  params.imageHeight[0] = H;
}

@end
