/*
 * node_functions.h
 *
 *  Created on: Jan 12, 2012
 *      Author: glausero
 */

#ifndef NODE_FUNCTIONS_H_
#define NODE_FUNCTIONS_H_

typedef enum{
	I2C_ID_BROADCAST = 0x04,
	I2C_COMPLETE = 0x01,
	I2C_SPLITTER = 0x02,
	SET_LED = 0x07,
	CALIB = 0x20,
	NEW_NODE = 0x44,
	COLOR = 0x22
} NodeCommand;

typedef struct{
	uint16_t zero_angles[3];
	uint16_t splitter_roll[5];
	uint16_t splitter_pitch[5];
	uint16_t splitter_yaw[5];
	uint8_t color_rgb[3];
} config_data_flash_struct;

/* function prototypes */
void set_in_Flash(config_data_flash_struct *setup);
void set_color(uint16_t rate_r, uint16_t rate_g, uint16_t rate_b);
void calibrate_angles();
uint8_t calibrate_splitter(uint16_t yaw, uint16_t pitch, uint16_t roll, uint8_t splitter_output);
void set_leds(uint16_t rate_r, uint16_t rate_g, uint16_t rate_b);
void set_type(uint8_t module_type);
void waiter_config();
void wait(uint16_t usTime);
void wait_ms(uint16_t msTime);
void topo_config();
void led_config();
void send_topo(uint16_t PIN);
void restart_slaves();
ErrorStatus is_splitter(uint8_t type_test);
ErrorStatus is_joint(uint8_t type_test);

#endif /* NODE_FUNCTIONS_H_ */
