#ifndef SERIAL_LINE_HANDLER_H
#define SERIAL_LINE_HANDLER_H

#include "Serial.h"
#include <string>

class SerialLineHandler : public Serial {
      
  public:
    SerialLineHandler(const std::string & dev, 
            void (*fb_func)(void*,const std::string &), void * ctxt );
    void update();

    void setMaxSize(unsigned int s) {max_size = s;}

    void reset() {
        line.clear();
    }
    
  protected:
    void (*fb_func)(void *,const std::string &);
    void * context;
    std::string line;
    unsigned int max_size;
};

#endif // SERIAL_LINE_HANDLER_H
