#ifndef Serial_H
#define Serial_H

#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <termios.h>
#include <string>

#define APPLE_IMPL

class Serial
{
	private :
        std::string device;
		int fd;
		fd_set rfs;
		//structure definie dans /bits/termios.h
		struct termios newtio;
#ifdef APPLE_IMPL
                struct termios original_tio;
#endif

	public :
		Serial(const std::string & dev);
		~Serial();
		bool Open(unsigned int speed);
		bool Close();
		size_t Send(const std::string & text) const {
            return Send((const unsigned char*)text.c_str(),text.size());
        }
		size_t Send(const unsigned char * data,size_t size) const;
		size_t Receive(unsigned char * data,size_t size);
		bool WaitData(size_t millisec);
		bool EmptyBuffers();

		bool isOpen() {return fd>=0;}
};	


#endif // Serial_H
