#include "SerialLineHandler.h"

SerialLineHandler::SerialLineHandler(unsigned int devId, 
        void (*handler)(void *, const std::string &),
        void * ctxt) : D2XXSerial(devId) ,
    fb_func(handler), context(ctxt), line(""), max_size(128) { }


void SerialLineHandler::process_data(){
    
    for (unsigned int i=0;i<data.size();i++) {
        unsigned char ch = data.front();
        data.pop_front();
        if (ch == '\n') {
            fb_func(context,line);
            line.clear();
        } else {
            line += ch;
        }
    }
    if (line.size() >= max_size) {
        fb_func(context,line);
        line.clear();
    }
    // We're signaling the condition here, but since we've eaten all the data
    // this just means that the line has been updated.
    D2XXSerial::process_data();
}


