#ifndef SERIAL_LINE_HANDLER_H
#define SERIAL_LINE_HANDLER_H

#include "D2XXSerial.h"
#include <string>

class SerialLineHandler : public D2XXSerial {
      
  public:
    SerialLineHandler(unsigned int devId,
            void (*fb_func)(void*,const std::string &), void * ctxt );

    void setMaxSize(unsigned int s) {max_size = s;}

    void reset() {
        line.clear();
    }
    
  protected:
    void (*fb_func)(void *,const std::string &);
    void * context;
    std::string line;
    unsigned int max_size;

    virtual void process_data();
};

#endif // SERIAL_LINE_HANDLER_H
