#ifndef Serial_H
#define Serial_H

#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <termios.h>
#include <string>
#include <list>
#include <ftd2xx.h>

class D2XXSerial
{
	protected :
        bool shuttingDown;
        unsigned int devIndex;
        FT_HANDLE	ftHandle;
        int  iNumDev;
        static const unsigned int MAX_DEVICES=64;
        char cBufLD[MAX_DEVICES][64];

        static void* static_read_thread(void *);
        void reading_loop();

        pthread_t th_id;
        pthread_mutex_t data_mtx;
        pthread_cond_t data_cond;

        std::list<unsigned char> data;

        virtual void process_data();

	public :
		D2XXSerial(unsigned int index=0);
		virtual ~D2XXSerial();
		bool Open(unsigned int speed);
		bool Close();
		size_t Send(const std::string & text) {
            return Send((const unsigned char*)text.c_str(),text.size());
        }
		size_t Send(const unsigned char * data,size_t size);
		size_t Receive(unsigned char * data,size_t size);
		bool WaitData(size_t millisec);
		bool EmptyBuffers();

		bool isOpen() {return (bool)ftHandle;}
};	


#endif // Serial_H
