/* This file is part of the source code for the following publication:
 * Assembling Self-Supporting Structures, Deuss et al., SIGGRAPH Asia 2014
 *
 * Copyright (C) 2014 Mario Deuss <mario.deuss@epfl.ch>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include <iostream>
#include "Timer.h"
#include "SelfAssemblyPlugin.h"

using namespace SelfAssembly;

std::string obj("Data/fig1.obj");
std::string ifs("Data/fig1.ifs");

int main (int argc, char *argv[])
{
	SelfAssemblyPlugin p;
	p.loadBlocksFile(&obj);
	p.loadInterfacesFile(&ifs);

	AnalyzerParameter ap;
	if(!ap.load("Data/ap.txt")){
		std::cerr << "Loading AnalyzerParameter failed! Aborting." << std::endl;
		return 1;
	}
	std::cout << ap;

	p.staticAnalysis(ap,true);

	SelfAssemblyPlugin::IPriorities ips;
	p.computePriorities(ap,ips);
	p.sequenceAnalysis(ap,true,false,NULL,&ips,false,false,false);

	return 0;
}
