/* This file is part of the source code for the following publication:
 * Assembling Self-Supporting Structures, Deuss et al., SIGGRAPH Asia 2014
 *
 * Copyright (C) 2014 Mario Deuss <mario.deuss@epfl.ch>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef SELF_ASSEMBLY_UTILS_H
#define SELF_ASSEMBLY_UTILS_H

#include "SelfAssemblyDefines.h"

namespace SelfAssembly{

class Utils{
	
private:
	Utils(){;}
	
public:
	static bool intersects(const V &a, const V &b, const V &c, 
						   const V &o, const V &dir, 
						   V* bc=NULL, double tMin =10e-6, double tMax = std::numeric_limits<double>::max());
	
	//samples evenly in a circle spanned in x,y, center at 0, radius 1. Last entry in return is 0, the z-coordinate.
	static V sampleCircle();
	static V incircleCenter(const V &a, const V &b, const V &c );
	static double incircleRadius(const V &a, const V &b, const V &c );
};

}

#endif
