/* This file is part of the source code for the following publication:
 * Assembling Self-Supporting Structures, Deuss et al., SIGGRAPH Asia 2014
 *
 * Copyright (C) 2014 Mario Deuss <mario.deuss@epfl.ch>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef QPMOSEK_H
#define QPMOSEK_H

#include "QP.h"
#include "Timer.h"

namespace SelfAssembly{

class QPMosek : public QP
{
public:
	QPMosek();
	virtual ~QPMosek();

	virtual bool solve( const S& H, const V& f,
						const S& A, const V& b,
						const S& C,	const V& d,
						const V& lb,const V& ub,
						V& _x, const V* _x0=NULL,
						const Cones* cones=NULL,
						bool _debug=false);
	
	virtual std::string report() const;
	virtual double functionValue() const { return fVal_;}
	virtual int exitFlag() const { return xFlag_;}

	bool test() const;

	void setNTasks( int n ){ nTasks_ = n; }
	int nTasks() const { return nTasks_; }
	
	void setThreshold( double t){ mP_ = t;}
	double threshold(){ return mP_;}
	
	std::string exitFlagToString( int _xflag ) const;

private:
	Timer tSetup,tSolve;
	void* env_;
	double fVal_;
	int xFlag_;
	int nTasks_;
	double mP_;
};
}

#endif // QPMOSEK_H
