/* This file is part of the source code for the following publication:
 * Assembling Self-Supporting Structures, Deuss et al., SIGGRAPH Asia 2014
 *
 * Copyright (C) 2014 Mario Deuss <mario.deuss@epfl.ch>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "QPFactory.h"

#include "QPMosek.h"

namespace SelfAssembly{

QP *QPFactory::make(QPFactory::QPType t, bool _storeVariables)
{
	QP* qp=NULL;

	switch( t ){

		case QPTYPE_BEGIN:
			return qp;

		case QPTYPE_END:
			return qp;
			
		case QPMOSEKT:
			qp = new QPMosek();
			break;

	}

	qp->setStoreVariables(_storeVariables);
	return qp;
}

void QPFactory::typeToString(QPFactory::QPType t, std::string &s)
{
	switch( t ){
		case QPTYPE_BEGIN:	s = std::string("Invalid QP Type");
		break;
		case QPTYPE_END:	s = std::string("Invalid QP Type");
		break;
		break;
		case QPMOSEKT:		s = std::string("QPMosek");
		break;
	}
}

}
