/* This file is part of the source code for the following publication:
 * Assembling Self-Supporting Structures, Deuss et al., SIGGRAPH Asia 2014
 *
 * Copyright (C) 2014 Mario Deuss <mario.deuss@epfl.ch>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef SELF_ASSEMBLY_LOADER_H
#define SELF_ASSEMBLY_LOADER_H

#include <string>
#include "Assembly.h"
#include "Sequence.h"
#include "AnalyzerParameter.h"

namespace SelfAssembly{

class Loader{
	
private: 
	Loader(){;}
	~Loader(){;}
	
public:

	static bool uniqueFilename( const std::string& filePathName,
								const std::string& fileExtension,
								std::string& uniqueFullFileName );
	static bool fileDialog( std::string& file );
	static bool loadBlocksFromFile(Assembly &_assembly, std::string& _lastDir, std::string* _fileName=NULL);
	static bool writeBlocksToFile(Assembly &a, std::string& _lastDir, std::string* _fileName=NULL);

	//_assembly already has to contain all the blocks and faces references by the ifs file
	static bool loadInterfacesFromFile(Assembly &_assembly, std::string& _lastDir, std::string *_fileName=NULL);
	static bool writeInterfacesToFile(const Assembly &a, std::string *_fileName=NULL);

	static bool loadSequenceFromFile( Sequence& s, std::string& _lastDir, std::string *_fileName=NULL);
	static bool writeSequenceToFile(const SelfAssembly::AnalyzerParameter& ap, const Sequence &s, std::string &_lastDir, std::string *_fileName);
};

}

#endif
