/* This file is part of the source code for the following publication:
 * Assembling Self-Supporting Structures, Deuss et al., SIGGRAPH Asia 2014
 *
 * Copyright (C) 2014 Mario Deuss <mario.deuss@epfl.ch>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef AABB_H
#define AABB_H

#include "SelfAssemblyDefines.h"

/*
* Simple Axis Aligned Bounding Box
*/
namespace SelfAssembly{


  class AABB {
    
  public:

    ////types
    typedef double Scalar;
    typedef Vector3 Point;
	typedef Vector3 Vector;

    ////(de)construction
    explicit AABB();
    virtual ~AABB();

    ////data access
    inline void set(const Point& _min, const Point& _max) { min_=_min; max_=_max; }
    inline void setMin(const Point& _min) { min_=_min; }
    inline void setMax(const Point& _max) { max_=_max; }
    inline const Point& getMin() const { return min_; }
    inline const Point& getMax() const { return max_; }


    ////convenience routines
    const Point getCenter() const;
	Scalar getRadius() const;
	Vector getDiagonal() const { return getMax() - getMin(); }

    ////getter/setter of empty flag
    // the bounding box is assumed to be empty, as soon as the min/max values go into an invalid state
    bool isEmpty() const;
    void setEmpty();

    ////growing functions
    void extend(const AABB& _aabb);
    void extend(const Point& _point);
    inline void extend(const Scalar _vectorX, const Scalar _vectorY, const Scalar _vectorZ) {
      extend(Point(_vectorX,_vectorY,_vectorZ));
    }


  private:
    Point min_;//vector containing the minima of the box at all axes
    Point max_;//vector containing the maxima of the box at all axes

  };


}//namespaces

#endif
