#ifndef SEAMLESSSIMILARITYMAPSPLUGIN_HH
#define SEAMLESSSIMILARITYMAPSPLUGIN_HH

#include <QObject>
#include <QMenuBar>

#include <OpenFlipper/BasePlugin/BaseInterface.hh>
#include <OpenFlipper/BasePlugin/LoadSaveInterface.hh>
#include <OpenFlipper/BasePlugin/ToolboxInterface.hh>
#include <OpenFlipper/BasePlugin/TextureInterface.hh>
#include <OpenFlipper/common/Types.hh>
#include <ObjectTypes/TriangleMesh/TriangleMesh.hh>
#include <ObjectTypes/PolyMesh/PolyMesh.hh>

#include "SeamlessSimilarityMapsToolbar.hh"

class SeamlessSimilarityMapsPlugin : public QObject, BaseInterface, LoadSaveInterface, ToolboxInterface, TextureInterface
{
  Q_OBJECT
  Q_INTERFACES(BaseInterface)
  Q_INTERFACES(LoadSaveInterface)
  Q_INTERFACES(ToolboxInterface)
  Q_INTERFACES(TextureInterface)
#if QT_VERSION >= 0x050000
  Q_PLUGIN_METADATA(IID "org.OpenFlipper.Plugins.Plugin-SeamlessSimilarityMaps")
#endif

  signals:

    void updateView();
    void updatedObject(int, const UpdateType&);
  
    // ToolboxInterface
    void addToolbox( QString _name, QWidget* _widget );
  
    // LoadSaveInterface
    void addEmptyObject(DataType typId, int& idx);
    
    // TextureInterface
    void addTexture( QString _name, QString _filename, uint _dimension, int _id );
    void switchTexture( QString _textureName, int _id );
    void switchTexture( QString _textureName );
    void updatedTextures( QString _textureName, int _id );
    void setTextureMode( QString _textureName, QString _mode, int _id );
    void textureChangeImage( QString _textureName , QImage& _image , int _id );

  public :

    ~SeamlessSimilarityMapsPlugin() {};

    QString name() { return (QString("SeamlessSimilarityMaps")); };
    QString description( ) { return (QString("Seamless Similarity Maps")); };

  private :

      /// Widget for Toolbox
      SeamlessSimilarityMapsToolbarWidget* tool_;

  private slots:
    
    // BaseInterface
    void initializePlugin();

    void slotCompute();

  private:
    void slotCompute( TriMesh* _mesh, QString filename );
    
    std::vector< std::vector<int> >  noncontractible_cycle_basis(const TriMesh& m);

   public slots:
      QString version() { return QString("1.0"); };
};

#endif //SEAMLESSSIMILARITYMAPSPLUGIN_HH
