# -*- coding: utf-8 -*-
#
# NanoGUI documentation build configuration file, created by
# sphinx-quickstart on Mon Aug 22 20:05:54 2016.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import os
import shlex
import textwrap

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath('.'))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.ifconfig',
    'breathe'
]

breathe_projects = { "NanoGUI": "./doxyoutput/xml" }
breathe_default_project = "NanoGUI"

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'NanoGUI'
copyright = u'2016, Wenzel Jakob'
author = u'Wenzel Jakob'

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '0.1.0'
# The full version, including alpha/beta/rc tags.
release = '0.1.0'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ['_build']

# The reST default role (used for this markup: `text`) to use for all
# documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
#keep_warnings = False

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = False

# Tell sphinx what the primary language being documented is.
primary_domain = 'cpp'

# Tell sphinx what the pygments highlight language should be.
highlight_language = 'cpp'


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
# on_rtd is whether we are on readthedocs.org, this line of code grabbed from docs.readthedocs.org
on_rtd = os.environ.get('READTHEDOCS', None) == 'True'

if not on_rtd:  # only import and set the theme if we're building docs locally
    import sphinx_rtd_theme
    html_theme = 'sphinx_rtd_theme'
    html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]
# html_theme = 'alabaster'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
#html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
#html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
#html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = '../resources/icons/icon6.ico'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
#html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_domain_indices = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
#html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Language to be used for generating the HTML full-text search index.
# Sphinx supports the following languages:
#   'da', 'de', 'en', 'es', 'fi', 'fr', 'hu', 'it', 'ja'
#   'nl', 'no', 'pt', 'ro', 'ru', 'sv', 'tr'
#html_search_language = 'en'

# A dictionary with options for the search language support, empty by default.
# Now only 'ja' uses this config value
#html_search_options = {'type': 'default'}

# The name of a javascript file (relative to the configuration directory) that
# implements a search results scorer. If empty, the default will be used.
#html_search_scorer = 'scorer.js'

# Output file base name for HTML help builder.
htmlhelp_basename = 'NanoGUIdoc'

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
# The paper size ('letterpaper' or 'a4paper').
#'papersize': 'letterpaper',

# The font size ('10pt', '11pt' or '12pt').
#'pointsize': '10pt',

# Additional stuff for the LaTeX preamble.
#'preamble': '',

# Latex figure (float) alignment
#'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
  (master_doc, 'NanoGUI.tex', u'NanoGUI Documentation',
   u'Wenzel Jakob', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# If true, show page references after internal links.
#latex_show_pagerefs = False

# If true, show URL addresses after external links.
#latex_show_urls = False

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_domain_indices = True


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    (master_doc, 'nanogui', u'NanoGUI Documentation',
     [author], 1)
]

# If true, show URL addresses after external links.
#man_show_urls = False


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
  (master_doc, 'NanoGUI', u'NanoGUI Documentation',
   author, 'NanoGUI', 'One line description of project.',
   'Miscellaneous'),
]

# Documents to append as an appendix to all manuals.
#texinfo_appendices = []

# If false, no module index is generated.
#texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
#texinfo_show_urls = 'footnote'

# If true, do not generate a @detailmenu in the "Top" node's menu.
#texinfo_no_detailmenu = False


def generateDoxygenXML(stripPath):
    '''
    Generates the doxygen xml files used by breathe and exhale.
    Approach modified from:

    - https://github.com/fmtlib/fmt/blob/master/doc/build.py

    :param stripPath:
        The value you are sending to exhale.generate via the
        key 'doxygenStripFromPath'.  Usually, should be '..'.
    '''
    from subprocess import PIPE, Popen
    try:
        doxygen_cmd = ["doxygen", "-"]# "-" tells Doxygen to read configs from stdin
        doxygen_proc  = Popen(doxygen_cmd, stdin=PIPE)
        doxygen_input = r'''
            # Make this the same as what you tell exhale.
            OUTPUT_DIRECTORY       = doxyoutput
            # If you need this to be YES, exhale will probably break.
            CREATE_SUBDIRS         = NO
            # So that only include/ and subdirectories appear.
            FULL_PATH_NAMES        = YES
            STRIP_FROM_PATH        = "%s/"
            # Tell Doxygen where the source code is (yours may be different).
            INPUT                  = ../include
            # Nested folders will be ignored without this.  You may not need it.
            RECURSIVE              = YES
            # Set to YES if you are debugging or want to compare.
            GENERATE_HTML          = NO
            # Unless you want it?
            GENERATE_LATEX         = NO
            # Both breathe and exhale need the xml.
            GENERATE_XML           = YES
            # Set to NO if you do not want the Doxygen program listing included.
            XML_PROGRAMLISTING     = YES
            # Allow for rst directives and advanced functions (e.g. grid tables)
            ALIASES                = "rst=\verbatim embed:rst:leading-asterisk"
            ALIASES               += "endrst=\endverbatim"
            # We definitely need the preprocessor for this project.
            ENABLE_PREPROCESSING   = YES
            MACRO_EXPANSION        = YES
            EXPAND_ONLY_PREDEF     = NO
            SKIP_FUNCTION_MACROS   = NO
            PREDEFINED             = NAMESPACE_BEGIN(nanogui)="namespace nanogui {"
            PREDEFINED            += NAMESPACE_END(nanogui)="}"
            PREDEFINED            += NAMESPACE_BEGIN(detail)="namespace detail {"
            PREDEFINED            += NAMESPACE_END(detail)="}"
            PREDEFINED            += DOXYGEN_SHOULD_SKIP_THIS
            PREDEFINED            += DOXYGEN_DOCUMENTATION_BUILD
            PREDEFINED            += NANOGUI_EXPORT
        ''' % stripPath
        # In python 3 strings and bytes are no longer interchangeable
        if sys.version[0] == "3":
            doxygen_input = bytes(doxygen_input, 'ASCII')
        doxygen_proc.communicate(input=doxygen_input)
        doxygen_proc.stdin.close()
        if doxygen_proc.wait() != 0:
            raise RuntimeError("Non-zero return code from 'doxygen'...")
    except Exception as e:
        raise Exception("Unable to execute 'doxygen': {}".format(e))


# setup is called auto-magically for you by Sphinx
def setup(app):
    stripPath = ".."
    generateDoxygenXML(stripPath)

    # generate description text for the library api
    libraryDescription = textwrap.dedent('''
    Welcome to the developer reference to NanoGUI.  The documentation is actively being
    developed / updated.  If you would like to help document any part of the project
    you may be familiar with, please refer to the :ref:`developer_contribution` page.

    .. note::
       Presented below is only the C++ API. If you are using the Python API, the
       contents below are still applicable for understanding what methods are available.
       While the documentation for the C++ API is useful as a reference for
       understanding what a given class does, the Python API does differ.  Please refer
       to the more concise :ref:`nanogui_example_2` for comparing the differences
       between the C++ and Python interfaces.
    ''')


    # create the dictionary to send to exhale
    exhaleArgs = {
        "doxygenIndexXMLPath"        : "./doxyoutput/xml/index.xml",
        "containmentFolder"          : "./generated_api",
        "rootFileName"               : "library_root.rst",
        "rootFileTitle"              : "Library API",
        "fullToctreeMaxDepth"        : 1,
        "createTreeView"             : True,
        "afterTitleDescription"      : libraryDescription,
        "doxygenStripFromPath"       : ".."
    }

    # import the exhale module from the current directory and generate the api
    from exhale import generate
    generate(exhaleArgs)
