/**************************************************************
 * This file is part of Deform Factors demo.                  *
 * Project web page:                                          *
 *    http://vcg.isti.cnr.it/deformfactors/                   *
 *                                                            *
 * Copyright (c) 2013 Marco Tarini <marco.tarini@isti.cnr.it> *
 *                                                            *
 * Deform Factors Demo is an implementation of                *
 * the algorithms and data structures described in            *
 * the Scientific Article:                                    *
 *    Accurate and Efficient Lighting for Skinned Models      *
 *    Marco Tarini, Daniele Panozzo, Olga Sorkine-Hornung     *
 *    Computer Graphic Forum, 2014                            *
 *    (presented at EUROGRAPHICS 2014)                        *
 *                                                            *
 * This Source Code is subject to the terms of                *
 * the Mozilla Public License v. 2.0.                         *
 * One copy of the license is available at                    *
 * http://mozilla.org/MPL/2.0/.                               *
 *                                                            *
 * Additionally, this Source Code is CITEWARE:                *
 * any derivative work must cite the                          *
 * above Scientific Article and include the same condition.   *
 *                                                            *
 **************************************************************/

#ifndef MESH_H
#define MESH_H

/* class Mesh: a rigged mesh */

#include "base_types.h"

#include <vector>
class Pose;
class PoseDQS;

// how many bone-links per vertex:
const int MAX_BONES = 4;

//typedef Eigen::Vector2f Vec2;

class Vert{
public:
    Vert(){}
    Vec3 pos; // xyz position
    Vec2 uv; // texture position
    Vec3 norm; // normal

    Vec3 tang; // tangent dir
    Vec3 bitang; // bi-tangent dir

#ifdef USE_GLSL_120
    typedef float indexType;
#else
    typedef char indexType;
#endif

    indexType boneIndex[MAX_BONES];

    float boneWeight[MAX_BONES];

    float deformFactorsTang[MAX_BONES]; /* see paper */
    float deformFactorsBtan[MAX_BONES]; /* see paper */

    float isTextureFlipped; /* -1 if the texture is flipped, 1 otherwise */

    /* helper functions */
    float weightOfBone(int i) const;
    int slotOfBone(int i);
    bool operator < (const Vert &b) const;
    void orderBoneSlots();
    void maybeSwapBoneSlots(int i, int j);

    /* UN-USED: only for testing numerical in-stability of naive solution */
    Vec3 weightGradient[MAX_BONES];

};

class Face{
public:
    int index[3];

    Face() {}
    Face(int i, int j, int k) {index[0]=i; index[1]=j; index[2]=k; }

};

class Mesh{
public:
    bool isEmpty() const;

    Mesh();
    std::vector<Vert> vert;
    std::vector<Face> face;

    void setUniformRig(int nbone);

    void computeDeformFactors();
    void computeTangentDirs();
    void computeIsTextureFlipped();
    void computeNormals();

    void orderBoneSlots();
    void unifyVertices();
    void removeUnreferencedVertices();

    void freezeAt(const Pose &p);
    void freezeAt(const PoseDQS &p);
    void clear();
    void test();

};

#endif
