/**************************************************************
 * This file is part of Deform Factors demo.                  *
 * Project web page:                                          *
 *    http://vcg.isti.cnr.it/deformfactors/                   *
 *                                                            *
 * Copyright (c) 2013 Marco Tarini <marco.tarini@isti.cnr.it> *
 *                                                            *
 * Deform Factors Demo is an implementation of                *
 * the algorithms and data structures described in            *
 * the Scientific Article:                                    *
 *    Accurate and Efficient Lighting for Skinned Models      *
 *    Marco Tarini, Daniele Panozzo, Olga Sorkine-Hornung     *
 *    Computer Graphic Forum, 2014                            *
 *    (presented at EUROGRAPHICS 2014)                        *
 *                                                            *
 * This Source Code is subject to the terms of                *
 * the Mozilla Public License v. 2.0.                         *
 * One copy of the license is available at                    *
 * http://mozilla.org/MPL/2.0/.                               *
 *                                                            *
 * Additionally, this Source Code is CITEWARE:                *
 * any derivative work must cite the                          *
 * above Scientific Article and include the same condition.   *
 *                                                            *
 **************************************************************/


#include <QApplication>
#include "mainwindow.h"
MainWindow *mw;

void saveColorRampImage(){
    FILE *f = fopen("color_ramp.pnm","wt");
    int dimx=40, dimy=180;
    fprintf(f,"P3\n%d %d\n255\n",dimx,dimy);
    for (int i=0;i<dimy;i++){

        /* recreates color function */
        float err=cos( 2.0*M_PI*i/360.0 );
        err = (err+1.0)*0.5;
        err*=err*err;
        int a = round((0.8)*255.0);
        int b = round((0.8)*err*255.0);

        for (int j=0;j<dimx;j++) {
            fprintf(f,"%d %d %d ",a,b,b);
        }
        fprintf(f,"\n");
    }
    fclose(f);
}

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    mw = new MainWindow;
    mw->show();
    return app.exec();
}
