// IGL Viewer - Copyright (c) 2013 ETH Zurich. All rights reserved.

// Class that handles loading of plugins.
// To add a new plugin DO NOT EDIT this file, see readme.txt

#ifndef Preview3D_PluginManager_h
#define Preview3D_PluginManager_h

#include "ViewerPlugin.h"
#include <vector>

// Keeps the lists of plugins
class _PluginManager_
{
private:
    
    _PluginManager_() {}
    friend _PluginManager_& PluginManager();
    friend class Preview3D;

    
public:  //-- SYSTEM PART------------------------------------------------------
    
    
    /** Registers a new plugin. A call to this function should be
     implemented in the constructor of all classes derived from PreviewPlugin. */
    bool register_plugin(PreviewPlugin* _bl)
    {
        plugin_list_.push_back(_bl);
        return true;
    }
private:
    
    // stores registered reader modules
    std::vector<PreviewPlugin*> plugin_list_;    
};


_PluginManager_& PluginManager();

#endif
