clear all
close all

sigma = .02;
%K = @(t) exp(-(t/sigma).^2/2); %Gaussian
K = @(t) (1-(t/sigma).^2).*exp(-(t/sigma).^2/2); %Uncomment for Ricker

rng(6,'twister');
Delta = 5*sigma; %Spike separation
gamma =  .25*sigma; %Sample separation
jit = 1/50; %sample jitter
L = 0;
R = 1;
meshWidth = .001;
mesh = L:meshWidth:R;
[spikeLocs, spikeVals, sampLocs] = generateData(Delta, gamma, jit,L+.05,R-.05,L,R,meshWidth,L);
sampVals = sampleKernel(K,spikeLocs,spikeVals,sampLocs);

%Solve the exact recovery problem
[tvspikeLocs,tvspikeVals,tvdualVar] = tvMin(K, sampLocs, sampVals, mesh);
dualData = sampleKernel(K,sampLocs,tvdualVar,mesh);
generatePlots(K, spikeLocs, spikeVals, sampLocs, sampVals, mesh, tvspikeLocs, tvspikeVals);
generateDualPlot(K, spikeLocs, spikeVals, sampLocs, mesh, tvdualVar);

%Dense noise
xi = 1
noise = randn(size(sampVals));
noise = noise/norm(noise)*xi;
sampValsNoise = sampVals + noise;
signalAmt = norm(sampVals)
snr = 20*log10(signalAmt/xi)
[tvLocs,tvVals] = tvMinNoise(K,sampLocs,sampValsNoise, mesh,1.25*xi);
generatePlotsNoise(K, spikeLocs, spikeVals, sampLocs, sampValsNoise, mesh, tvLocs, tvVals,'Dense Noise');

%Sparse noise
sparseFrac = .2; %Probability each sample is corrupted
lambda = 2; %Optimization parameter
sampValsSparse = addNoise(sampVals, sparseFrac);
[tvSparseLocs,tvSparseVals,tvSparseNoiseLocs,tvSparseNoiseVals,tvDualVar] = tvMinSparse(K,sampLocs,sampValsSparse, mesh,lambda);
generatePlotsNoise(K, spikeLocs, spikeVals, sampLocs, sampValsSparse, mesh, tvSparseLocs, tvSparseVals,'Sparse Noise');
