function [spikeLocs, spikeVals, sampLocs] = generateData(Delta, gamma, jit,a,b,sa,sb,meshWidth,L)
%Generates regular spike locations, normally distributed values, and 
%regular sample locations from the given parameters with optional jitter.
%All constructed vectors are rows.
%Delta: Spike separation used
%gamma: Sample proximity used
%jit: Sample jitter used.
    spikeLocs = a:Delta:b;
    spikeLocs = L+round((spikeLocs-L)/meshWidth)*meshWidth;
    spikeVals = randn(size(spikeLocs));
    Nsamps = ceil((sb-sa)/gamma);
    s = gamma*(1+jit*(rand(1,Nsamps)-1/2));
    s(1) = sa;
    sampLocs = cumsum(s);
end