//header file to call in MoveMeshWithConstraint


func int MoveMeshWithConstraint(real dmesh, real pressure,int firstQ)
{

   //needs:
   //Th == mesh (implicitly assumes simply connected region, no doughnut shape
   //u,v == finite element displacement field defined over Th

   if(firstQ==0) {
      Th=adaptmesh(Th,dmesh,IsMetric=1);
      Th=adaptmesh(Th,dmesh,IsMetric=1);
      Th=adaptmesh(Th,dmesh,IsMetric=1);
      //cout << " hello " << endl;
      //plot(Th,wait=1);
   } else
   {
   mesh Eh = emptymesh(Th);
   //mesh Eh = adaptmesh(Th,[u,v]);
   //Eh = adaptmesh(Eh,[u,v]);
   //Eh = adaptmesh(Eh,[u,v]);

   fespace Fh(Eh,P1);

   //plot(Eh,wait=1);

   
   Fh uf2;

   varf vnx(unused,uf2) = int1d(Eh)(N.x/lenEdge*uf2);
   Fh nx;
   nx[] = vnx(0,Fh);
   varf vny(unused,uf2) = int1d(Eh)(N.y/lenEdge*uf2);
   Fh ny;
   ny[] = vny(0,Fh);

   real A0 = int2d(Eh)(1.0);
   real cmx= int2d(Eh)(x);
   cmx = cmx/A0;
   real cmy= int2d(Eh)(y);
   cmy = cmy/A0;

   //u = u + ((1)?pressure*nx:0);
   //v = v + ((ny>0)?pressure*ny:0);

   //v = v+((ny>0)?pressure:0); //simple velocity displacement

   varf vcurvature(unused,uf2) = int1d(Eh)(sqrt((dx(nx)*N.y-dy(nx)*N.x)^2+(dx(ny)*N.y-dy(ny)*N.x)^2)/lenEdge*uf2); //curvature, using equation t' = k n
   Fh curvature;
   curvature[] = vcurvature(0,Fh);
   Fh du,dv;

   Fh uu = u;
   Fh vv = v;

   //add some artificial pressure
   //uu = uu - ((ny>=0.0)?nx*pressure*curvature:0.0);
   //vv = vv - ((ny>=0.0)?ny*pressure*curvature:0.0);

   //uu = coeff*u;
   //vv = coeff*v;

   //0.3 here scales the membrane tension contribution, the term in bracket
   //that follows 0.3 should be the derivative of the tension, need to
   //check notebook 071810 KCL
   varf vun(unused,uf2) = int1d(Eh)((uu*N.x+vv*N.y+((N.y>0.0)?(pressure):0.0)+pressure*0.3*((-dx(nx)*N.y+dy(nx)*N.x)*N.y+(dx(ny)*N.y-dy(ny)*N.x)*N.x))/lenEdge*uf2);
   //varf vun(unused,uf2) = int1d(Eh)(((uu+((y>cmy)?(pressure*N.x):0.0))*N.x+(vv+((y>cmy)?(pressure*N.y):0.0))*N.y)/lenEdge*uf2);
   //varf vun(unused,uf2) = int1d(Eh)(((uu+((N.y>0.0)?(pressure*N.x):0.0))*N.x+(vv+((N.y>0.0)?(pressure*N.y):0.0))*N.y)/lenEdge*uf2);
   Fh un; un[] = vun(0,Fh);  //normal component of displacement vector
   varf vdun(unused,uf2) = int1d(Eh)((N.x*dy(un)-N.y*dx(un))/lenEdge*uf2);
   Fh dun; dun[] = vdun(0,Fh); //variation of normal component

   real A =  2.*pi;
   real B = int1d(Eh)(1.);
   B = B + int1d(Eh)(2.*(curvature*un));
   B = B + int1d(Eh)(1.*(curvature*(y*N.x-x*N.y)));
   real C = int1d(Eh)(1.*(un));
   C = C + int1d(Eh)(1.*(un*curvature*(y*N.x-x*N.y+un)));
   C = C + int1d(Eh)(1.*(dun*(x*N.x+y*N.y)));
   real lambdaP = sqrt(B*B-4*A*C);
   real lambdaN = (-B-lambdaP)/A*0.5;
   lambdaP = (-B+lambdaP)/A*0.5;
   if(lambdaP*lambdaP > lambdaN*lambdaN) {lambdaP=lambdaN;}
   cout << "lambda = " << lambdaP << " " << lambdaN << endl;
   varf vdu(unused, uf2) = int1d(Eh)((un+lambdaP)*N.x/lenEdge*uf2);
   du[]=vdu(0,Fh);
   varf vdv(unused, uf2) = int1d(Eh)((un+lambdaP)*N.y/lenEdge*uf2);
   dv[]=vdv(0,Fh);

   real minT0 = checkmovemesh(Eh,[x,y]);
   real coeff  = 1.0; 
   while(1) 
   {
      real minT = checkmovemesh(Eh,[x+coeff*du, y+coeff*dv]); 
      if(minT>minT0*0.5) break;
      coeff=coeff/1.5;
   }

   Eh = movemesh(Eh,[x+coeff*du,y+coeff*dv]);
   Th = adaptmesh(Eh,dmesh,IsMetric=1);
   Th = adaptmesh(Th,dmesh,IsMetric=1);
   Th = adaptmesh(Th,dmesh,IsMetric=1);
   //Th = adaptmesh(Eh,[u,v]);
   //Th = adaptmesh(Th,[u,v]);
   //Th = adaptmesh(Th,[u,v]);
   //Th = adaptmesh(Th,[u,v]);
   //plot(Eh0,Eh,wait=1);
   }
}


