
void readtrack(void)
{
	int i;
	char tmp[50];
	FILE *fp;

	n_track=(int) (t/smp_dt);
	
	t_seq=malloc(n_track*sizeof(float));
	thb_seq=malloc(n_track*sizeof(float));
	x_seq=malloc(n_track*sizeof(float));
	y_seq=malloc(n_track*sizeof(float));
	v_seq=malloc(n_track*sizeof(float));
	ktailall=malloc(n_track*sizeof(float));
	dNlr_seq=malloc(n_track*sizeof(float));
	dNf_seq=malloc(n_track*sizeof(float));
	dNa_seq=malloc(n_track*sizeof(float));
	
	fp=fopen("track.dat", "r");
	fscanf(fp, "%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s", tmp, tmp, tmp, tmp, tmp, tmp, tmp, tmp);
	for(i=0; i<n_track; i++) {	// thb_seq is in degrees !
		fscanf(fp, "%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f", &t_seq[i], &thb_seq[i], 
			&x_seq[i], &y_seq[i], &v_seq[i], &dNlr_seq[i], &dNf_seq[i], &dNa_seq[i]);
	}
	fclose(fp);
}


void smooth3pt(float s1[], float s2[])
{
	int i;
	s2[0]=s1[0];
	for(i=1; i<n_track-1; i++) s2[i]=(s1[i-1]+s1[i+1]+2*s1[i])/4.0;
	s2[n_track-1]=s1[n_track-1];
}


void smooth5pt(float s1[], float s2[])
{
	int i;
	s2[0]=s1[0];
	s2[1]=(s1[0]+s1[2]+2*s1[1])/4.0;
	for(i=2; i<n_track-2; i++) s2[i]=(s1[i-2]+s1[i+2]+4*(s1[i-1]+s1[i+1])+6*s1[i])/16.0;
	s2[n_track-2]=(s1[n_track-3]+s1[n_track-1]+2*s1[n_track-2])/4.0;
	s2[n_track-1]=s1[n_track-1];
}


void smooth7pt(float s1[], float s2[])
{
	int i;
	s2[0]=s1[0];
	s2[1]=(s1[0]+s1[2]+2*s1[1])/4.0;
	s2[2]=(s1[0]+s1[4]+4*(s1[1]+s1[3])+6*s1[2])/16.0;
	for(i=3; i<n_track-3; i++) {
		s2[i]=(s1[i-3]+s1[i+3]+6*(s1[i-2]+s1[i+2])+15*(s1[i-1]+s1[i+1])+20*s1[i])/64.0;
	}
	s2[n_track-3]=(s1[n_track-5]+s1[n_track-1]+4*(s1[n_track-4]+s1[n_track-2])+6*s1[n_track-3])/16.0;
	s2[n_track-2]=(s1[n_track-3]+s1[n_track-1]+2*s1[n_track-2])/4.0;
	s2[n_track-1]=s1[n_track-1];
}


void smoothfunc(float s1[], float s2[])
{	
	if(n_track>7) smooth7pt(s1, s2);
	
	/*
	smooth3pt(s1, s2);
	
	smooth5pt(s1, s2);
	
	smooth7pt(n1, s2);
	*/
}


float convolution(float x[], int ix, int di, int di2db, int mi)
{
	int i;
	float z;

	z=0.0;
	for(i=ix-mi; i<ix+mi; i++) {
		z+=x[i]*exp(-pow(i-ix,2)/di2db);
	}
	z/=sqrt(Pidb)*di;
	return z;
}


void smoothtrack(void)
{
	int i, il, ir, di, mi, di2db;
	int nw, nwm;
	float dlen, *x, *y, *th;

	dlen=vbd_ave*smp_dt;
	nw=(int)(smoothwindow/dlen+0.5);	// Gaussian window
	nw=max2(nw,1);
	nwm=icutoff*nw;	// Gaussian window cutoff

	x=malloc(n_track*sizeof(float));	// temporary arrays
	y=malloc(n_track*sizeof(float));
	th=malloc(n_track*sizeof(float));
	
	smoothfunc(x_seq, x);	// step 1: 7-pt smoothing
	smoothfunc(y_seq, y);
	smoothfunc(thb_seq, th);

	x_seqsm=malloc(n_track*sizeof(float));	// step 2: Gaussian smoothing
	y_seqsm=malloc(n_track*sizeof(float));
	thb_seqsm=malloc(n_track*sizeof(float));

	// two boundaries
	for(i=0; i<icutoff; i++) { x_seqsm[i]=x[i]; y_seqsm[i]=y[i]; thb_seqsm[i]=th[i]; }
	for(i=n_track-icutoff; i<n_track; i++) { x_seqsm[i]=x[i]; y_seqsm[i]=y[i]; thb_seqsm[i]=th[i]; }

	for(i=icutoff; i<n_track-icutoff; i++) {	// Gaussian smoothing
		il=i;
		ir=n_track-1-i;
		mi=min2(min2(il, ir), nwm);	// max smoothing range for i
		di=max2(mi/icutoff, 1);	// sigma_width of smoothing
		di2db=2*di*di;
		
		x_seqsm[i]=convolution(x,i,di,di2db,mi);
		y_seqsm[i]=convolution(y,i,di,di2db,mi);
		thb_seqsm[i]=convolution(th,i,di,di2db,mi);
	}

	free(x);
	free(y);
	free(th);
}


void getvbd_ave(void)
{
	int i;
	double r1[2], r2[2];
	vbd_ave=0.0;
	for(i=1; i<n_track; i++) {
		r1[0]=x_seqsm[i-1];	r1[1]=y_seqsm[i-1];
		r2[0]=x_seqsm[i];	r2[1]=y_seqsm[i];
		vbd_ave+=distance(r1,r2);
	}
	vbd_ave/=t;
}

//------------------- get yaw angle from smoothed track ------------------

void getyaw(void)
{
	int i, ia, ib;
	double dr[2], vbangle, yawangle;
	
	yaw_seq=malloc(n_track*sizeof(float));
	
	for(i=0; i<n_track; i++) {
		if(i==0) {ia=i; ib=i+1;}
		else if(i==n_track-1) {ia=i-1; ib=i;}
		else {ia=i-1; ib=i+1;}
		
		dr[0]=x_seqsm[ib]-x_seqsm[ia];
		dr[1]=y_seqsm[ib]-y_seqsm[ia];
		Crt2LabPol(dr, &vbangle);	// -pi< vbangle <pi
		yawangle=vbangle-thb_seqsm[i]*d2r;	// thb_seq is in degrees !
		limityaw(&yawangle);	// limit 0<x<pihalf, for yaw angle
		yaw_seq[i]=yawangle*r2d;
	}
}


//------------------- get omg's from smoothed track ------------------

void getomgfunc(float x[], float y[], float w[])
{
	int i;
	double r1[2], r2[2];
	for(i=1; i<n_track-1; i++) {
		r1[0]=x[i]-x[i-1];
		r1[1]=y[i]-y[i-1];
		r2[0]=x[i+1]-x[i];
		r2[1]=y[i+1]-y[i];
		w[i]=getanglesign(r1,r2)*r2d/smp_dt;	// in degrees, right turn +, left turn -
	}
	w[0]=w[1];
	w[n_track-1]=w[n_track-2];
}


void getomg_tl(void)	// omg_tail in lab
{
	int i;
	omg_tl=malloc(n_track*sizeof(float));
	for(i=0; i<n_track; i++) omg_tl[i]=0.0;
	getomgfunc(x_seqsm, y_seqsm, omg_tl);
}


void getomg_bd(void)	// omg_bead in lab
{
	int i, ia, ib, di;
	float dth;
	
	omg_bd=malloc(n_track*sizeof(float));
	for(i=0; i<n_track; i++) {
		if(i==0) {ia=i; ib=i+1; di=1;}
		else if(i==n_track-1) {ia=i-1; ib=i; di=1;}
		else {ia=i-1; ib=i+1; di=2;}
		dth=(thb_seqsm[ib]-thb_seqsm[ia])/di;	// thb is not limited within (-180,180)
		omg_bd[i]=dth/smp_dt;	// in degrees
	}
}


void getomg_bdtl(void)	// omg_bead in tail
{
	int i;
	omg_bdtl=malloc(n_track*sizeof(float));
	for(i=0; i<n_track; i++) omg_bdtl[i]=omg_bd[i]-omg_tl[i];
}


void getomgs(void)
{
	getomg_tl();
	getomg_bd();
	getomg_bdtl();
}


//------------------- get ktail from smoothed track ------------------

float MinFunc(float para[])	// para[4], but only 1-3 are used as parameters
{	// sum_i [(xi-xc)^2+(yi-yc)^2-R^2]^2 should be minimized by choosing proper xc, yc and R
	int i;
	float zi, z;
	z=0.0;
	for(i=0; i<NCurvatureSpanTotal; i++) {	// for all relevant points
		zi=pow(xiselect[i]-para[1],2)+pow(yiselect[i]-para[2],2)-pow(para[3],2);
		z+=zi*zi;
	}
	return z;
}


void dMinFunc(float para[], float df[])	// para[4] & df[4], but only 1-3 are used as parameters
{	// derivative of MinFunc with respect to para[1], para[2] and para[3]
	int i;
	float zi;
	df[0]=df[1]=df[2]=df[3]=0.0;
	for(i=0; i<NCurvatureSpanTotal; i++) {
		zi=pow(xiselect[i]-para[1],2)+pow(yiselect[i]-para[2],2)-pow(para[3],2);
		df[1]+=zi*(xiselect[i]-para[1]);
		df[2]+=zi*(yiselect[i]-para[2]);
		df[3]+=zi;
	}
	df[1]*=-4;	// df/dp1
	df[2]*=-4;	// df/dp2
	df[3]*=-4*para[3];	// df/dp3
}


void LeastSquareMinimization(float ktailall[], float xcktail[], float ycktail[])
{	// Conjugate-Gradient Method to minimize MinFunc()
	int i, j, k, iter, z;
	float para[4], fret;
	
	para[0]=0.0;	// no in use
	for(i=NCurvatureSpan; i<n_track-NCurvatureSpan; i++) {	// center point
		for(j=-NCurvatureSpan; j<=NCurvatureSpan; j++) {	// choose neighboring fitting points
			k=j+NCurvatureSpan;
			xiselect[k]=x_seqsm[i+j];
			yiselect[k]=y_seqsm[i+j];
		}
		para[1]=xcktail[i];	// estimate of xc, yc and R, to make minimization faster & more accurate
		para[2]=ycktail[i];
		para[3]=1.0/ktailall[i];
		z=frprmn(para, 3, 1e-4, &iter, &fret, MinFunc, dMinFunc);	// Fletcher-Reeves Polak-Ribiere minimization
		if(z==1) ktailall[i]=1.0/max2(fabs(para[3]),1.0e-6);	// fitted curvature
		ktailall[i]=min2(ktailall[i], 100.0);	// in 1/micron
	}
}


void getKtail(void)
{
	int i, j, il, ir, di, cnt;
	double ds, r1[2], r2[2], r3[2], rc[2];
	double ki, kave, krms, kcut;
	float *xcktail, *ycktail;
	FILE *fp;
	
	xcktail=malloc(n_track*sizeof(float));
	ycktail=malloc(n_track*sizeof(float));
	
	ds=vbd_ave*smp_dt;
	NCurvatureSpan=(int)(CurvatureWidthHalf/ds+0.5);	// previous typo here!
	NCurvatureSpan=max2(NCurvatureSpan,1);
	NCurvatureSpanTotal=2*NCurvatureSpan+1;
	xiselect=malloc(NCurvatureSpanTotal*sizeof(double));
	yiselect=malloc(NCurvatureSpanTotal*sizeof(double));

	// rough estimate
	for(i=1; i<n_track-1; i++) {
		il=i-NCurvatureSpan;
		ir=i+NCurvatureSpan;
		di=NCurvatureSpan;
		if(il<0 || ir>=n_track) {
			if(il<0) di=i;	// beyond left
			else if(ir>=n_track) di=n_track-1-i;	// beyond right
			else di=1;	// beyond both
		}
		r1[0]=x_seqsm[i-di];	r1[1]=y_seqsm[i-di];
		r2[0]=x_seqsm[i];		r2[1]=y_seqsm[i];
		r3[0]=x_seqsm[i+di];	r3[1]=y_seqsm[i+di];
		getcurvaturecenter(r1, r2, r3, &ki, rc);
		ktailall[i]=ki;
		xcktail[i]=rc[0];
		ycktail[i]=rc[1];
	}

	if(n_track==1) ktailall[0]=xcktail[0]=ycktail[0]=0.0;
	else if(n_track>=2) {
		ktailall[0]=ktailall[1];
		xcktail[0]=xcktail[1];
		ycktail[0]=ycktail[1];
		ktailall[n_track-1]=ktailall[n_track-2];
		xcktail[n_track-1]=xcktail[n_track-2];
		ycktail[n_track-1]=ycktail[n_track-2];
	}
	
	fp=fopen("kr1.dat", "w");
	fprintf(fp, "#i\tK\tR\n");
	for(i=0; i<n_track; i++) fprintf(fp, "%d\t%f\t%f\n", i, ktailall[i], 1/ktailall[i]);
	fclose(fp);
	
	// reduce noise in ktailall by least-square fitting
	if(n_track>NCurvatureSpanTotal) LeastSquareMinimization(ktailall, xcktail, ycktail);
	
	free(xcktail);
	free(ycktail);
	free(xiselect);
	free(yiselect);

	fp=fopen("kr2.dat", "w");
	fprintf(fp, "#i\tK\tR\n");
	for(i=0; i<n_track; i++) fprintf(fp, "%d\t%f\t%f\n", i, ktailall[i], 1/ktailall[i]);
	fclose(fp);
	
//--- start truncating high curvatures due to stalled bead ---
	kave=krms=0.0;
	cnt=0;
	for(i=0; i<n_track; i++) {
		if(ktailall[i]<2.0) {	// ignore curvatures greater than 2/um
			kave+=ktailall[i];
			krms+=pow(ktailall[i],2);
			cnt++;
		}
	}
	cnt=max2(cnt,1);
	kave/=cnt;
	krms/=cnt;
	krms=sqrt(krms);
	
	kcut=10.0*max2(kave,krms);
	
	n_ktail=0;
	for(i=0; i<n_track; i++) {
		if(ktailall[i]<kcut) n_ktail++;
	}
	
	if(n_ktail==0) {
		ktail=malloc(sizeof(float));
		ktail[0]=0.0;
		free(ktailall);
		return;
	}
	
	ktail=malloc(n_ktail*sizeof(float));
	j=0;
	for(i=0; i<n_track; i++) {
		if(ktailall[i]<kcut && j<n_ktail) ktail[j++]=ktailall[i];
	}
}

//----------- overall ------------

void savetrack(void)
{
	int i;
	FILE *fp;
	fp=fopen("track_sm.dat", "w");
	fprintf(fp, "#t\tyaw\tthb\tx\ty\n");
	for(i=0; i<n_track; i++) fprintf(fp, "%.2f\t%.2f\t%.2f\t%.2f\t%.2f\n", 
		t_seq[i], yaw_seq[i], thb_seqsm[i], x_seqsm[i], y_seqsm[i]);
	fclose(fp);
	
	fp=fopen("omg_sm.dat", "w");
	fprintf(fp, "#t\tomg_bd\tomg_tl\tomg_bdtl\n");
	for(i=0; i<n_track; i++) fprintf(fp, "%.2f\t%.3g\t%.3g\t%.3g\n", 
		t_seq[i], omg_bd[i], omg_tl[i], omg_bdtl[i]);
	fclose(fp);
}


void ProcessTrack(void)
{
	readtrack();
	smoothtrack();
	if(n_track>=3) {
		getvbd_ave();
		getyaw();
		getomgs();
		getKtail();
		savetrack();
	}
}



