

void getdli(double r1[2], double r2[2], double l0, double *dl, double dLvec[2])
{	// given r1, r2, l0, find dli in lab frame
	double r[2], l, n[2];
	
	vecsub(r2,r1,r);
	l=norm(r);
	*dl=l-l0;
	if(*dl==0.0) veczero(dLvec);
	else {
		normalize(r,n);
	#if VAR_KS
		*dl *= 0.1/l0;	// variable ksnode
	#endif
		vecprod(n, *dl, dLvec);
	}
}


void NodeForce(void)	// force from other nodes's in lab frame
{
	int i;
	double dLi[2];
	graph_node *p, *q;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		veczero(p->DLvec);	// total extensions in lab frame
		q = p->next;
		while(q) {	// connected nodes
			getdli(p->R0, q->R0, q->l0, &(q->dl), dLi);
			vecadd(p->DLvec, dLi, p->DLvec);	// add to total deformation of the node
			q = q->next;
		}
		Lab2Loc(p->DLvec, p->dlvec);	// in bead frame
	}
}


void avoidbead(double r[2], double dr[2])
{	// to avoid bead, r in bead frame, dr in lab frame
	double alf, alf2;
	double drloc[2], nr[2];
	
	alf2=pow(r[0],2)/Ra2+pow(r[1],2)/Rb2;
	if(alf2<1.0) {	// inside the bead
		alf=sqrt(alf2);
		nr[0]=r[0]/Ra2;
		nr[1]=r[1]/Rb2;
		normalize(nr,nr);
		vecprod(nr,(1.0-alf)*Rmax,drloc);
		Loc2Lab(drloc, dr);
		vecsub(Ftop, dr, Ftop);	// push back on bead
	}
}


void limitnodemotion(graph_node *p, double dr[2])
{	// dr is the dislocation of node
	double n;
	n=max2(p->nnbr, 1.0);
	if(p->contact==1) n+=ksfila_nodem1;	// replace one link with ksnode/ksfila	
	if(mjunodeksdt>1.0/n) vecdiv(p->DLvec, n, dr);
}


void getLocalProps(graph_node *p, int newnode)	// from R0, get r0, r1, R1 & (Rtip)!!!
{
	double r[2];
	
	vecsub(p->R0, Rcenter, r);	// R0 translates to bead center
	Lab2Loc(r, p->r0);	// rotates to bead frame
	
#if !LPD_CT
	if(p->attached && !newnode) {	// old att filament stick to surface, r0 & r1 do not change
		Loc2Lab(p->r1, r);
		vecadd(r, Rcenter, p->R1);	// R1 changes due to bead's motion
		
		vecsub(p->R1, p->R0, r);
		normalize(r, r);
		vecprod(r, p->len, p->Rtip);
		vecadd(p->Rtip, p->R0, p->Rtip);	// Rtip = R0 + (R1-R0)/|R1-R0|*l0
		return;
	}
#endif

	ProjectBeadNormal(p->r0, p->r1, p->nrm);	// from r0, get r1 & outward nrm
	Loc2Lab(p->r1, r);	// R1 in lab frame
	vecadd(r, Rcenter, p->R1);
	
	
	vecsub(p->R1, p->R0, r);
	normalize(r, r);
	vecprod(r, p->len, p->Rtip);
	vecadd(p->Rtip, p->R0, p->Rtip);	// Rtip = R0 + (R1-R0)/|R1-R0|*l0
}


double getTau(graph_node *p)	// calc in bead frame!!!
{
	double a, b, h, tau;
	if(p->nrm[0]==0.0) h=fabs(p->r1[0]);
	else {
		a=(p->nrm[1])/(p->nrm[0]);	// slope
		b=(p->r1[1])-a*(p->r1[0]);
		h=fabs(b)/sqrt(1+a*a);
	}
	tau=norm(p->ftip)*h;
	if(crossprod(p->r1, p->nrm)<0.0) tau*=-1;	// f||-nr
	return tau;
}


void GelBeadInteract(void)	// use node's ksnode as base unit
{
	int i;
	double dloc[2], dlab[2], dlfila[2];	// effective dl when two springs are connected
#if LPD_CT
	double dlnrm;
#endif
	graph_node *p;

	Taubead=0.0;

	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->contact && p->capped==0) {	// for all active filaments
			if(p->attached) {	// attached filaments
				vecsub(p->R1, p->Rtip, dlfila);	// force from filament to node in lab frame
				Lab2Loc(dlfila, dlfila);	// in bead frame
			
			#if LPD_CT
				dlnrm=dotprod(dlfila, p->nrm);
				vecprod(p->nrm, dlnrm, dlfila);
			#endif
			}
			else if(p->dlen>0) {	// free filament that is actually in contact with bead
				vecprod(p->nrm, p->dlen, dlfila);	// force from filament to node in bead frame
			}
			else veczero(dlfila);

			if(!(p->attached==0 && p->dlen<0)) {	// if not left-behind free filaments
				if(p->dlen>0) limitvector(dlfila, dl_buckle);	// limited by buckling
				vecprod(dlfila, ksfila_node, dloc);
				vecadd(p->dlvec, dloc, p->dlvec);
		
				Loc2Lab(dloc, dlab);	//lab frame
				vecadd(p->DLvec, dlab, p->DLvec);	// lab frame
				
				vecprod(dloc, -1, p->ftip);	// in bead frame
				vecprod(dlab, -1, p->Ftip);	// in lab frame

				if(Ra!=Rb) Taubead+=getTau(p);	// torque
				
				vecadd(Ftop, p->Ftip, Ftop);
			}
		}	// end of if p->contact
	}
}



void NodeBeadMotion(void)
{
	int i;
	double dr[2];
	graph_node *p, *q;

	Ncontact=Nfree=Natt=0;
	veczero(Ftop);
	Taubead=0.0;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		getLocalProps(p,0);	// from R0, get r0, r1 & R1
		
		if(NodeInDeformRegion(p->r0)) p->deformable = 1;
		else p->deformable = 0;
		
		if(NodeInContactRegion(p->r0)) {	// node is interacting with bead
			p->contact = p->bnd = 1;
			Ncontact++;
			if(p->capped == 0) {
				if(p->attached==0) Nfree++;
				else Natt++;
			}
		}
		else {	// node is outside of the interaction region
			p->contact = 0;
			p->attached = 0;
			p->capped = 1;
			p->dlen = 0.0;
		}
	}

	GelBeadInteract();	// update dlvec & DLvec, Ftop & Taubead

	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->deformable) {
			vecprod(p->DLvec, mjunodeksdt, dr);
			limitnodemotion(p, dr);	// don't move bottom nodes if pulling
			avoidbead(p->r0, dr);	// update Ftop
			vecadd(p->R0, dr, p->R0);
			if(p->capped == 0) vecadd(p->Rtip, dr, p->Rtip);
		}
	}

	Nnotcontact=Nnodes-Ncontact;
	Nfila=Nfree+Natt;

	for(i=0; i<Nnodes; i++) {
		p = graph[i]->next;	// neighbors
		while(p) {
			q = graph[p->id];	// find the head node
			veccopy(q->R0, p->R0);	// update R0 from head node
			p = p->next;
		}
	}
}

void UpdateNodes(void)
{
	int i;
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		getLocalProps(p,0);	// 0 for old filas
	}
}


void RelaxNetwork(void)
{
	int i;
	for(i=0; i<1; i++) {
		FilaDeform();
		NodeForce();
		NodeBeadMotion();
	}
}


void FlushTracking(int n)
{
	int i;
	FILE *fp;
	
	fp=fopen("track.dat","a");
	for(i=0; i<n; i++) {
		fprintf(fp, "%.4g\t%.2f\t%.4g\t%.4g\t%.4f\t%.4g\t%.4g\t%.4g\n", 
			smp_t_buffer[i], smp_thb_buffer[i], smp_r_buffer[i][0], smp_r_buffer[i][1], 
			smp_v_buffer[i], dNlr_buffer[i], dNf_buffer[i], dNa_buffer[i]);
	}
	fclose(fp);
}


void getdNlr(double *dn, double *dnf, double *dna)
{
	int i, left;
	double vloc[2];
	double nl, nr, nt, nfl, nfr, nft, nal, nar, nat;
	graph_node *p;
	
	Lab2Loc(Vcenter, vloc);	// v in bead's frame
	nl=nr=nt=0.0;
	nfl=nfr=nft=nal=nar=nat=0.0;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->contact) {
			nt++;
			if(crossprod(vloc, p->nrm)>0.0) left=1;
			else left=0;
			
			if(left) nl++;	// node on the left side
			else nr++;
				
			if(p->attached) {	// attached
				nat++;
				if(left) nal++;
				else nar++;
			}
			else {	// free
				nft++;
				if(left) nfl++;
				else nfr++;
			}
		}
	}
	*dn=(nl-nr)/max2(nt,1.0);	// fraction of L-R difference
	*dnf=(nfl-nfr)/max2(nft,1.0);
	*dna=(nal-nar)/max2(nat,1.0);
}


void SaveTracking(void)
{
	int i;
	if(smp_cnt >= smp_cnt_max) {
		
		if(smp_sav_cnt>smp_bufferm1) {
			smp_sav_cnt=0;
			FlushTracking(smp_buffer);
		}
		i=smp_sav_cnt;
		smp_t_buffer[i]=t;
		smp_thb_buffer[i]=thb*r2d;
		veccopy(Rcenter, smp_r_buffer[i]);
		smp_v_buffer[i]=dspl_Vave;
		getdNlr(&dNlr_buffer[i], &dNf_buffer[i], &dNa_buffer[i]);
		
		smp_sav_cnt++;
		smp_cnt=0;
	}
	smp_cnt++;
}


void GelMotion(void)
{
#if FILGRW
	FilaDynamics();
	FilaGrowth();
#endif

#if GELMOV
	SaveTracking();
	for(igelrelax=0; igelrelax<GelBeadRelax; igelrelax++) {
		RelaxNetwork();
		UpdateNodes();	// update R1 after plate movement
		
		if(ran2(&mseed)<0.1) {
			CheckConnectivity();	// do this before wholegel, coarse, and relax motion
			SolveRelaxation();
			RelaxNetwork();
			UpdateNodes();	// update R1 after plate movement
		}
	}
#endif
}


void limitbeadmotion(double dl[2], double dr[2], int neff)	
{
	double fct;
	double limdr[2];
	
	vecdiv(dl, neff, limdr);
	if(norm(limdr)<norm(dr)) veccopy(limdr, dr);	// limit dr
	
	fct=norm(dr)/v0dt;
	if(fct>1) vecdiv(dr, fct, dr);
}


void BeadMotion(void)
{
	int i, neff;
	double dr[2];
	
	neff=(int)(Ncontact/4);
	neff=max2(neff, 10);
	
	vecprod(Ftop, mjubeadksdt, dr);
	limitbeadmotion(Ftop, dr, neff);
	vecadd(Rcenter, dr, Rcenter);

	if(Ra!=Rb) {
		dthb=Taubead/Rave2/neff;
		thb+=dthb;
		thbd=thb*r2d;
		sthb=sin(thb);
		cthb=cos(thb);
	}
	
	if(++dspl_smp_cnt>=dspl_smp_skip) {
		if(dspl_smp_num<dspl_n_ave) dspl_smp_num++;
			
		vecsub(Rcenter, Rcenterprev, dr);
		vecdiv(dr, dspl_smp_dt*1.0e-3, Vcenter);	// vector V in nm/s for bead
		
		dspl_V[dspl_v_ptr]=norm(dr)/dspl_smp_dt;
		veccopy(Rcenter, Rcenterprev);
		
		dspl_Vave=0.0;
		for(i=0; i<dspl_smp_num; i++) dspl_Vave+=dspl_V[i];
		dspl_Vave/=(dspl_smp_num);
		
		dspl_smp_cnt=0;
		if(++dspl_v_ptr>=dspl_n_ave) dspl_v_ptr=0;
	}

}


