

void getdli(double r1[2], double r2[2], double l0, double *dl, double dLvec[2])
{	// given r1, r2, l0, find dli in lab frame
	double r[2], l, invl;
	
	vecsub(r2,r1,r);
	l=norm(r);
	invl=max2(l, 1.0e-9);
	*dl=l-l0;
	if(*dl==0.0) veczero(dLvec);
	else {
	#if VAR_KS
		*dl *= 0.1/l0;	// variable ksnode
	#endif
		vecprod(r, (*dl)/invl, dLvec);
	}
}


void plateforce(graph_node *p)	// force from plate-node interaction
{
	double dy;
	
#if INBEAD
	double dx, dr;
	dr=Rave-distance(p->R0,Rcenter);
	if(dr>0) {	// node touches bead
		dr*=(p->nnbr);	// dy>0 for compressing, convert displacement into force
		dx=dr*(p->nrm[0]);
		dy=dr*(p->nrm[1]);
		Ftop[1] += dy;	// force on gel from bead
		p->dlvec[0] += dx;
		p->dlvec[0] += dx;
		p->DLvec[1] += dy;
		p->dlvec[1] += dy;
	}
#else
	if(p->R0[1]>toppos[1]) {	// beyond the top plate
		dy = (p->R0[1] - toppos[1])*(p->nnbr);	// dy>0 for compressing, convert displacement into force
		Ftop[1] -= dy;	// force on gel from top plate
		p->DLvec[1] -= dy;
		p->dlvec[1] -= dy;
	}
#endif
	else if(p->R0[1]<botpos[1]) {	// beyond the bottom plate
		dy = (p->R0[1] - botpos[1])*(p->nnbr);	// dy<0 for compressing
		Fbot[1] -= dy;	// force on gel from bottom plate
		p->DLvec[1] -= dy;	// bottom plate on node
		p->dlvec[1] -= dy;
	}
}


void NodeNeighborForce(void)	// nighbor force on nodes, and plate force on nodes
{
	int i;
	double dLi[2];
	graph_node *p, *q;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		veczero(p->DLvec);	// total extensions
		q = p->next;
		while(q) {	// connected nodes
			getdli(p->R0, q->R0, q->l0, &(q->dl), dLi);	// dli is in lab
			vecadd(p->DLvec, dLi, p->DLvec);	// add to total deformation of the node
			q = q->next;
		}
		veccopy(p->DLvec, p->dlvec);
		plateforce(p);	// force from plates, also updates Ftop & Fbot
	}
}


void NodeFilaForce(void)	// filament force on nodes
{
	int i;
	double dloc[2], dlab[2], dlfila[2];	// effective dl when two springs are connected
#if !LPD_CT
//	double n[2];
#else
	double dln;
#endif
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->contact && p->capped==0) {	// for all active filaments
			if(p->attached) {	// attached filaments
				vecsub(p->R1, p->Rtip, dlfila);	// force from filament to node
			#if LPD_CT
				dln=dotprod(dlfila, p->nrm);
				vecprod(p->nrm, dln, dlfila);
			#endif
			}
			else if(p->dlen>0) {	// free filament that is actually in contact with bead
				vecprod(p->nrm, p->dlen, dlfila);	// force from filament to node in bead frame
			}

			if(!(p->attached==0 && p->dlen<0)) {	// if not left-behind free filaments
				if(p->dlen>0) limitvector(dlfila, dl_buckle);	// limited by buckling
				vecprod(dlfila, ksfila_node, dloc);	// convert to node's ks unit
				vecadd(p->dlvec, dloc, p->dlvec);	// add to total force on node, in bead frame
		
				veccopy(dloc, dlab);
				vecadd(p->DLvec, dlab, p->DLvec);
				
				vecprod(dloc, -1, p->ftip);	// in bead frame
				vecprod(dlab, -1, p->Ftip);	// in lab frame
				
				vecadd(Ftop, p->Ftip, Ftop);
			}
		}	// end of if p->contact
	}
}


void TotalNodeForce(void)	// get total p->dlvec, p->DLvec, and Ftop
{
	veczero(Ftop);
	veczero(Fbot);
	
	NodeNeighborForce();	// p->dlvec updated
	NodeFilaForce();	// p->dlvec and Ftop updated
}


void limitplatemotion(double dl[2], double dr[2])	
{
	int i;
	double limdr[2], n;
	graph_node *p;
	
	ntop=nbot=0;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->contact && (p->capped==0 || p->r0[1]>-eps)) {
			p->bnd = 1;
			ntop++;
		}
		else if(p->R0[1] < botlayercontact) {
			p->bnd = -1;
			nbot++;
		}
		else p->bnd = 0;
	}
	
	ntop=max2(ntop,1);
	nbot=max2(nbot,1);

	
	n=max2(0.5*ntop,1.0);
#if !CONSTF
	n+=kslever_node;
#endif

#if CIRBND
	vecdiv(dl, 2.0*n, limdr);
#else
	vecdiv(dl, n, limdr);
#endif
	limitvector(limdr,v0dt);
	if(norm(limdr)<norm(dr)) veccopy(limdr, dr);	// limit dr
}


void moveplate(double fext[2])	// update dtoppos inside
{
	int i, nfree, natt, nfreem1, flg;
	double fy, *posx, *pos, *f, dy, yfreemax, poszero;
	graph_node *p;

	flg=0;
	ntop=nbot=0;
	nfree=natt=0;
	poszero=0.0;
	veczero(dtoppos);

	fy=-fext[1];	// fy>0 if compressing, fy has length unit, actual force = fy*ksnode
	yfreemax=-inf;
	
	posx=malloc(Nnodes*sizeof(double));	// for all nodes
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->contact && p->capped==0) {
			p->bnd = 1;
			ntop++;
			if(p->attached) {	// att
				poszero += p->Rtip[1];
				natt++;
			}
			else {	// free
				posx[nfree] = p->Rtip[1];
				if(p->Rtip[1] > yfreemax) yfreemax = p->Rtip[1];
				nfree++;
			}
		}
		else if(p->R0[1] < botlayercontact) {
			p->bnd = -1;
			nbot++;
		}
		else p->bnd = 0;
	}

	if(natt>0) {
		poszero/=natt;
		poszero = toppos[1] - poszero;	// neutral position in bead/plate frame, down is +
	}
	
	if(ntop==0) flg=1;	// if no filaments, don't move
	else if(nfree==0) {	// if only att'd filaments, linear force-displacement relation
		dy=poszero+fy/natt/ksfila_node;	// fy>0 for compressing
		dtoppos[1]=-dy;
		flg=1;
	}
	else if(fy==0.0 && natt==0) {	// if no external force and only free filas
		dtoppos[1]=yfreemax-toppos[1];
		flg=1;
	}
	if(flg==1) { free(posx); return; }	// shortcut exit

	pos=malloc(nfree*sizeof(double));	// free filaments
	f=malloc(nfree*sizeof(double));
	for(i=0; i<nfree; i++) pos[i] = toppos[1] - posx[i];	// r=toppos-Rtip, down is +
	heapsort(pos, nfree);	// sorted pos[i]<=pos[i+1], longer filas have lower indecies
	
	f[0]=0.0;
	for(i=1; i<nfree; i++) {
		f[i]=f[i-1]+i*(pos[i]-pos[i-1])*ksfila_node;	// forces from free filas
	}
	if(natt>0) {
		for(i=0; i<nfree; i++) {
			f[i]+=natt*(pos[i]-poszero)*ksfila_node;	// adding forces from att filas
		}
	}
	
	nfreem1=nfree-1;
	if(fy>=f[nfreem1]) {	// force presses all working filaments (free+att)
		dy=pos[nfreem1]+(fy-f[nfreem1])/ntop/ksfila_node;	// extrapolation
	}
	else if(fy<f[0]) {	// pulling force, extrapolate
		if(natt>0) dy=pos[0]+(fy-f[0])/natt/ksfila_node;
		else {	// pulling on non-attached network, go away
		#if INBEAD
			dy=fy*beadmjudt;	// dy<=0
		#else
			dy=fy*platemjudt;
		#endif
		}
	}
	else {	// plate is somewhere between f[0] & f[nfreem1]
		i=1;
		while(f[i]<fy && i<nfreem1) i++;	// then f[i-1]<dl<=f[i], interpolation
		dy=pos[i-1]+(fy-f[i-1])/(i+natt)/ksfila_node;
	}
	
	dtoppos[1]=-dy;
	
	free(posx);
	free(pos);
	free(f);
	
	nfree=max2(nfree,1);
	nbot=max2(nbot,1);
}



void movebead(double fext[2])	// update dtoppos inside
{
	int i, nfree, natt, nfreem1, flg;
	int *idf, *ida;
	double fy, *posx, *pos, *f, dy, yfreemax, poszero;
	double *cs2f, *sumcs2f, cs2a, sumcs2a, yc0, rc0;
	graph_node *p;
	
	flg=0;
	ntop=nbot=0;
	nfree=natt=0;
	poszero=0.0;
	veczero(dtoppos);

	fy=-fext[1];	// fy>0 if compressing
	yfreemax=-inf;
	
	posx=malloc(Nnodes*sizeof(double));	// for all nodes
	idf=malloc(Nnodes*sizeof(int));	// id of free filaments
	ida=malloc(Nnodes*sizeof(int));	// id of att filaments
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->contact && p->capped==0 && fabs(p->Rtip[0]) <= Rave) {
			p->bnd = 1;
			ntop++;
			if(p->attached) {	// att
				poszero += p->Rtip[1] + sqrt(Rave2-pow(p->Rtip[0],2));
				ida[natt] = p->id;
				natt++;
			}
			else {	// free
				posx[nfree] = p->Rtip[1] + sqrt(Rave2-pow(p->Rtip[0],2));
				idf[nfree] = p->id;
				if(posx[nfree] > yfreemax) yfreemax = posx[nfree];
				nfree++;
			}
		}
		else if(p->R0[1] < botlayercontact) {
			p->bnd = -1;
			nbot++;
		}
		else p->bnd = 0;
	}
	
	if(natt>0) {
		poszero/=natt;
		poszero = Rcenter[1] - poszero;	// neutral position in bead/plate frame, down is +
	}
	
	if(ntop==0) flg=1;
	else if(nfree==0) {	// if only att'd filaments, linear force-displacement relation
		dy=poszero+fy/natt/ksfila_node;	// fy>0 for compressing
		dtoppos[1]=-dy;
		flg=1;
	}
	else if(fy==0.0 && natt==0) {	// if no external force and only free filas
		dtoppos[1]=yfreemax-Rcenter[1];	// move to the tip of the longest free filament
		flg=1;
	}
	if(flg==1) { free(posx); free(idf); free(ida); return; }

	pos=malloc(nfree*sizeof(double));
	cs2f=malloc(nfree*sizeof(double));
	sumcs2f=malloc(nfree*sizeof(double));
	f=malloc(nfree*sizeof(double));
	
	for(i=0; i<nfree; i++) pos[i] = Rcenter[1] - posx[i];	// in bead center frame, down is +

	heapsort2(pos, idf, nfree);	// sorted to be pos[i]<=pos[i+1], also rearrange ids according to pos

	for(i=0; i<nfree; i++) {	// get cos(th)^2 for each free filament
		p=graph[idf[i]];
		yc0=Rcenter[1]-(p->R0[1]);
		rc0=max2(distance(Rcenter, p->R0),eps);
		cs2f[i]=pow(yc0/rc0,2);	// cos^2 of angle between C-R0 and y-axis
		if(i==0) sumcs2f[i]=cs2f[i];
		else sumcs2f[i]=cs2f[i]+sumcs2f[i-1];
	}

	sumcs2a=0.0;
	for(i=0; i<natt; i++) {	// get sum_cos(th)^2 for all att filament
		p=graph[ida[i]];
		yc0=Rcenter[1]-(p->R0[1]);
		rc0=max2(distance(Rcenter, p->R0),eps);
		cs2a=pow(yc0/rc0,2);	// cos^2 of angle between C-R0 and y-axis
		sumcs2a+=cs2a;
	}
	
	f[0]=0.0;	// before touching the longest filament, force from filas is 0
	for(i=1; i<nfree; i++) {
		f[i]=f[i-1]+(pos[i]-pos[i-1])*sumcs2f[i-1]*ksfila_node;	// no (*i) here comparing to plate, it's in sumcs2f
	}
	if(natt>0) {
		for(i=0; i<nfree; i++) {
			f[i]+=(pos[i]-poszero)*sumcs2a*ksfila_node;	// adding forces from att filas
		}
	}

	nfreem1=nfree-1;	// nfreem1>=0
	if(fy>=f[nfreem1]) {	// force presses all working filaments (free+att)
		dy=pos[nfreem1]+(fy-f[nfreem1])/(sumcs2f[nfreem1]+sumcs2a)/ksfila_node;
	}
	else if(fy<f[0]) {	// pulling force, extrapolate
		if(natt>0) dy=pos[0]+(fy-f[0])/sumcs2a/ksfila_node;	// no free filas
		else {	// pulling on non-attached network, go away
		#if INBEAD
			dy=fy*beadmjudt;	// dy<=0
		#else
			dy=fy*platemjudt;
		#endif
		}
	}
	else {	// bead is somewhere between f[0] & f[nfreem1]
		i=1;
		while(f[i]<fy && i<nfreem1) i++;
		dy=pos[i-1]+(fy-f[i-1])/(sumcs2f[i-1]+sumcs2a)/ksfila_node;
	}
	dtoppos[0]=0.0;
	dtoppos[1]=-dy;
	
	free(idf);
	free(ida);
	free(posx);
	free(pos);
	free(cs2f);
	free(sumcs2f);
	free(f);
	
	ntop=max2(ntop,1);
	nbot=max2(nbot,1);
}


void PlateMotion(void)
{
	double nr[2], fext[2], dr;
	
	if(testdirection!=0 && teststart==1) teststart=0;
	
	if(testdirection==0) { nr[0]=nr[1]=0.0; }
	else if(testdirection==1) { nr[0]=0.0; nr[1]=-1.0; }	// move to -y
	else if(testdirection==2) { nr[0]=0.0; nr[1]=1.0; }	// move to +y
	else if(testdirection==3) { nr[0]=1.0; nr[1]=0.0; }	// move to +x
	else if(testdirection==4) { nr[0]=-1.0; nr[1]=0.0; }	// move to -x
	else return;
	
	if(testdirection==0) {
		veczero(dtoppos);	// to eliminate dr=eps
		veczero(dtoppostot);
	}
	else {
	#if HISTRY
		if(Fswitch==0) {	// varying/constant force -> constant force
			Floadtst=Fhold;
		}
		else {	// constant/varying force -> varying force
			Floadtst=(toppos[1]-Hleverrest)*ks_lever;
		}
	#else
		#if CONSTF
			Floadtst=Floadini;
		#else
			Floadtst=(toppos[1]-topposini[1])*ks_lever;
		#endif
	#endif
		dlloadtst=Floadtst/ksnode;
		vecprod(nr,dlloadtst,fext);	// external force converted to ksnode scale
		veccopy(fext, Fext);
	}
	
#if INBEAD
	movebead(fext);
#else
	moveplate(fext);	// update dtoppos inside
#endif

	vecadd(toppos, dtoppos, toppos);
#if INBEAD
	toppos[0]=0.0;
#endif
	vecadd(dtoppostot, dtoppos, dtoppostot);
	veccopy(toppos, Rcenter);
	
	if(testdirection==1 || testdirection==2) dr=fabs(dtoppostot[1]);	// vertical deformation
	else if(testdirection==3 || testdirection==4) dr=fabs(dtoppostot[0]);	// horizontal deformation
	if(testdirection==0) {
		if(fabs(dtoppostot[0])<1.0e-3) toppos[0]=topposini[0];
		if(fabs(dtoppostot[1])<1.0e-3) toppos[1]=topposini[1];
		Ymod=0.0;
	}
	else Ymod=Ymodfactor/max2(dr,eps);	// Young's modulus
}


// for testing gel with plate or cantilever-bead
void getLocalPropsTest(graph_node *p, int newnode)	// from R0, get r0, r1, nrm & R1
{
	vecsub(p->R0, toppos, p->r0);	// lab frame to plate frame, up is + if plate
	
#if !LPD_CT
	if(p->attached && !newnode) {	// old att filament stick to surface, r0 & r1 do not change
		vecadd(p->r1, toppos, p->R1);
	#if INBEAD
		p->nrm[0] = p->r1[0]/Ra2;	p->nrm[1] = p->r1[1]/Rb2;
		normalize(p->nrm, p->nrm);
	#else
		p->nrm[0] = 0.0;	p->nrm[1] = -1.0;
	#endif
		return;
	}
#endif

#if INBEAD
	ProjectBeadNormal(p->r0, p->r1, p->nrm);	// from r0, get r1 & outwards nrm
	vecadd(p->r1, Rcenter, p->R1);
#else
	p->r1[0] = p->r0[0];	// up is +, not along nrm
	p->r1[1] = 0.0;
	p->R1[0] = p->R0[0];
	p->R1[1] = toppos[1];
	p->nrm[0] = 0.0;
	p->nrm[1] = -1.0;
#endif
}

// for moving bead
void getLocalProps(graph_node *p, int newnode)	// from R0, get r0, r1, nrm & R1
{
	double r[2];
	
	vecsub(p->R0, Rcenter, r);	// R0 translates to bead center
	Lab2Loc(r, p->r0);	// rotates to bead frame
#if !LPD_CT
	if(p->attached && !newnode) {	// old att filament stick to surface, r0 & r1 do not change
		Loc2Lab(p->r1, r);
		vecadd(r, Rcenter, p->R1);
		return;
	}
#endif

	ProjectBeadNormal(p->r0, p->r1, p->nrm);	// from r0, get r1 & outwards nrm
	Loc2Lab(p->r1, r);	// R1 in lab frame
	vecadd(r, Rcenter, p->R1);
}


void limitnodemotion(graph_node *p, double dr[2])
{
	double n;
	
	n=max2(p->nnbr, 1.0);
	if(p->contact==1 && p->capped==0) n+=ksfila_nodem1;	// replace one link with ksnode/ksfila	
	if(n>mjunodeksdtinv) vecdiv(p->DLvec, n, dr);	// otherwise dr does not change
}


void GelMove(void)
{
	int i, j, id;
	double dr[2], r[2];
	graph_node *p, *q;
	
	Ncontact=Nfree=Natt=0;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		getLocalPropsTest(p,0);	// from R0, get r0, r1, nrm & R1; 0 for old filas
		
	#if INBEAD
		if(NodeInContactRegion(p->r0)) {	// node is inside the interaction regon
			p->contact = p->bnd = 1;
			Ncontact++;
			if(p->capped==0) {
				if(p->attached==0) Nfree++;
				else Natt++;
			}
		}
		else {	// node is outside the interaction region
			p->contact = 0;
			if(p->R0[1]>botlayercontact) p->bnd = 0;
			else p->bnd = -1;
			p->attached = 0;
			p->capped = 1;
			p->dlen = 0.0;
		}
	#else
		if(p->r0[1]>-toplayerthick) {	// node is inside the interaction regon, p->r0 is pointing to +y
			p->contact = p->bnd = 1;
			Ncontact++;
			if(p->capped==0) {
				if(p->attached==0) Nfree++;
				else Natt++;
			}
		}
		else {	// node is outside the interaction region
			p->contact = 0;
			if(p->R0[1]>botlayercontact) p->bnd = 0;
			else p->bnd = -1;
			p->attached = 0;
			p->capped = 1;
			p->dlen = 0.0;
		}
	#endif
		
	#if GELMOV
		if(p->bnd == -1) veczero(dr);	// no motion at bottom
		else {
			vecprod(p->DLvec, mjunodeksdt, dr);
			limitnodemotion(p, dr);	// don't move bottom nodes if pulling
			vecadd(p->R0, dr, p->R0);
		}
		
		if(LPD_CT || p->attached==0) {
			p->R1[0] += dr[0];
			p->r1[0] += dr[0];
		}
		if(p->capped == 0) vecadd(p->Rtip, dr, p->Rtip);
	#endif
	}

	Nnotcontact=Nnodes-Ncontact;
	Nfila=Nfree+Natt;
	
	for(i=0; i<Nnodes; i++) {	// update all the rest nodes' positions
		p=graph[i];	// the node
		id = p->id;
		veccopy(p->R0, r);
		for(j=0; j<Nnodes; j++) {
			q=graph[j]->next;
			while(q) {
				if(q->id == id) veccopy(r, q->R0);	// update all the rest nodes
				q = q->next;
			}
		}
	}
}



void UpdateNodes(void)
{
	int i;
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		getLocalPropsTest(p,0);	// 0 for old filas
	}
}


void addthermal(double n)
{
	int i;
	double fct;
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		fct=sqrt(n)*thermaldx/max2(sqrt(p->nnbr), 1);
		p->R0[0]+=fct*(1-2*ran2(&mseed));
		p->R0[1]+=fct*(1-2*ran2(&mseed));
	}
	UpdateNodes();
}
	


void RelaxNetwork(void)
{
	int i;
	for(i=0; i<3; i++) {
		FilaDeform();	// update p->dlen based on p->R0 and p->R1
		TotalNodeForce();	// update p->DLvec based on p->R0 and p->dlen
		GelMove();	// update p->R0(R1) based on p->DLvec, also updates Ftop
		UpdateNodes();	// update R1
	}
}


void GelPlateMotion(void)
{
	int i;
	
#if GELMOV
	for(i=0; i<GelBeadRelax; i++) {
		
		PlateMotion();	// move plate first, then gel
		UpdateNodes();	// update R1 after plate movement
		RelaxNetwork();
		
		CheckConnectivity();	// do this before wholegel, coarse, and relax motion
	
		if(ran2(&mseed)<0.2) {
			CoarseGrainMotion();	// include whole gel motion and gel-segment adjustment
			UpdateNodes();	// update R1 after plate movement
			RelaxNetwork();
		}

		WholeGelMotion();	// move whole gel together
		UpdateNodes();	// update R1 after plate movement
		RelaxNetwork();
	
		if(ran2(&mseed)<0.2) {
			SolveRelaxation();
			RelaxNetwork();
		}
	}
#else
	PlateMotion();	// move plate first, then gel
	UpdateNodes();	// update R1 after plate movement
	FilaDeform();	// update p->dlen based on p->R0 and p->R1
	TotalNodeForce();	// update p->DLvec based on p->R0 and p->dlen
	GelMove();	// update p->R0(R1) based on p->DLvec, also updates Ftop
	UpdateNodes();	// update R1 after plate movement
#endif
}


/*-------------------------------------
	save data
-------------------------------------*/

void FlushTest(int n)
{
	int i;
	FILE *fp;
	
	fp=fopen("testgel.dat","a");
	for(i=0; i<n; i++) {
		fprintf(fp, "%.4g\t%.4g\t%.4g\t%.4g\n", t_tst_buffer[i], 
			dr_tst_buffer[i][1], F_tst_buffer[i], v_tst_buffer[i]);
	}
	fclose(fp);
}


void SaveTest(void)
{
	int i;
	double dr[2];
	
//--- save to file ---
	if(cnt_tst_save >= n_tst_save) {
		cnt_tst_save=0;
		if(cnt_tst_buffer > N_tst_bufferm1) {
			cnt_tst_buffer=0;
			FlushTest(N_tst_buffer);
		}
		t_tst_buffer[cnt_tst_buffer]=t;
		veccopy(dtoppostot, dr_tst_buffer[cnt_tst_buffer]);
		
		vecsub(toppos, topposprev, dr);
		v_tst_buffer[cnt_tst_buffer]=norm(dr)/t_tst_save*1.0e3;	// in nm/s
	#if TSTGEL
		if(testdirection==1 || testdirection==2) v_tst_buffer[cnt_tst_buffer]*=sign(dr[1]);
		else if(testdirection>2) v_tst_buffer[cnt_tst_buffer]*=sign(dr[0]);
	#endif
		//v_tst_buffer[cnt_tst_buffer]=dspl_Vave*1e3;
		v_current_buffer=v_tst_buffer[cnt_tst_buffer];
		F_tst_buffer[cnt_tst_buffer]=Floadtst;

	#if CONSTF && CFTEST	// record v for const. F test
		if(t>=Tstart_CF && t<=Tend_CF) {
			v_ave_CF+=v_current_buffer*1.0e-3;	// in um/s
			cnt_v_CF++;
		}
	#endif
	
		veccopy(toppos, topposprev);
		
		Nbrklink_tst_buffer[cnt_tst_buffer]=0;	//Nlinksini-Nlinks;
		
	#if !OPENGL
		printf("%.4g\t%.4g\t%.4g\t%.4g\n", t, dtoppostot[1], 
		F_tst_buffer[cnt_tst_buffer], v_tst_buffer[cnt_tst_buffer]);
	#endif

		cnt_tst_buffer++;
	}
	cnt_tst_save++;
	
//--- show on screen ---
	if(++dspl_smp_cnt >= dspl_smp_skip) {
		dspl_smp_cnt=0;
		if(dspl_smp_num < dspl_n_ave) dspl_smp_num++;
			
		vecsub(Rcenter, Rcenterprev, dr);
		dspl_V[dspl_v_ptr]=norm(dr)/dspl_smp_dt;
	#if TSTGEL
		if(testdirection==1 || testdirection==2) dspl_V[dspl_v_ptr]*=sign(dr[1]);
		else if(testdirection>2) dspl_V[dspl_v_ptr]*=sign(dr[0]);
	#endif
		veccopy(Rcenter, Rcenterprev);
		
		dspl_Vave=0.0;
		for(i=0; i<dspl_smp_num; i++) dspl_Vave+=dspl_V[i];
		dspl_Vave/=(dspl_smp_num);
		
		if(++dspl_v_ptr >= dspl_n_ave) dspl_v_ptr=0;
	}
}



/*-------------------------------------
	overall
-------------------------------------*/

void GelPlateDynamics(void)
{
	if(testdirection!=0 || teststart==0) {
		SaveTest();
	#if FILGRW
		FilaDynamics();
		FilaGrowth();
	#endif
		GelPlateMotion();
	}
}

