
int CutOffBead(double r1[2], double r2[2])	// decide if line r1-r2 cuts the bead
{	// r1, r2 in bead frame
	double a, b, h;
	double a2, b2, c1, c2, c3, delta;
	double p1x, p2x, lmd1, lmd2;
	
	if(r1[0]==r2[0]) {
		if(fabs(r1[0])>Ra) return 0;
		else {
			if(unitdotprod(r1,r2)>CutTolerence) return 0;	// tolerance
			else return 1;
		}
	}
	a=(r2[1]-r1[1])/(r2[0]-r1[0]);	// slope
	b=r1[1]-a*r1[0];	// constant
	h=fabs(b)/sqrt(a*a+1.0);	// line is y=ax+b, h=distance from line to origin
	if(h>Rmax) return 0;
	else {	// find intersection in the bead frame
		a2=a*a;
		b2=b*b;
		delta=a2*Ra4Rb2+Ra2Rb4-b2*Ra2Rb2;
		if(delta<0.0) return 0;	// no intersection
		
		c1=-a*b*Ra2;
		c2=sqrt(delta);
		c3=a2*Ra2+Rb2;
	
		p1x=(c1+c2)/c3;	// intersections p1 & p2
		p2x=(c1-c2)/c3;
		
		lmd1=(p1x-r1[0])/(r2[0]-r1[0]);
		lmd2=(p2x-r1[0])/(r2[0]-r1[0]);
		if(lmd1>0.0 && lmd1<1.0 && lmd2>0.0 && lmd2<1.0) return 1;
		else return 0;
	}
}


void Points2Line(double r1[2], double r2[2], double *a, double *b)
{	// two points give a line y=ax+b
	if(r1[0]==r2[0]) {
		*a=inf;
		*b=r1[0];	// define b as the x-intercept
		return;
	}
	*a=(r2[1]-r1[1])/(r2[0]-r1[0]);
	*b=r1[1]-(*a)*r1[0];
}


void LineEllipseIntersect(double a, double b, double r1[2], double r2[2])
{	// given line y=ax+b, find intersections r1, r2
	double a2, b2, c1, c2, c3;
	
	if(a==inf) {	// define b as the x-intercept
		r1[0]=r2[0]=b;
		r1[1]=Rb*sqrt(1-b*b/Ra2);
		r2[1]=-r1[1];
		return;
	}
	a2=a*a;
	b2=b*b;
	
	c1=-a*b*Ra2;
	c2=a2*Ra2+Rb2-b2;
	if(c2<0.0) {printf("error in LineEllipseIntersect\n"); exit(0);}
	c2=RaRb*sqrt(c2);
	c3=a2*Ra2+Rb2;
	r1[0]=(c1+c2)/c3;
	r2[0]=(c1-c2)/c3;
	r1[1]=a*r1[0]+b;
	r2[1]=a*r2[0]+b;
}

void LineLineIntersect(double a1, double b1, double a2, double b2, double r[2])
{	// given y=a1*x+b1 & y=a2*x+b2, find intersection r
	double a12;
	a12=a1-a2;
	if(a12==0.0) {printf("error in LineLineIntersect\n"); exit(0);}
	r[0]=-(b1-b2)/a12;
	r[1]=(a1*b2-a2*b1)/a12;
}

void ProjectBeadNormal(double r0[2], double r1[2], double nr[2])	// in bead frame
{	// find bead normal nr that passes through r0, also find site r1 on the bead
	double a, b, a1, a2, b1, b2, c;
	double ra[2], rb[2], rA[2], rB[2], rC[2];
	
	if(Ra==Rb) {	// circular bead
		normalize(r0, nr);
		vecprod(nr, Ra, r1);	// r1 in bead frame
		return;
	}
	
	if(NodeOnBead(r0)) {
		nr[0]=r0[0]/Ra2;
		nr[1]=r0[1]/Rb2;
		normalize(nr,nr);
		veccopy(r0,r1);
		return;
	}
	
	Points2Line(r0,Focus1,&a,&b);	// line P-F1
	LineEllipseIntersect(a,b,ra,rb);	// two intersections
	if(distance(r0,ra)<distance(r0,rb)) veccopy(ra,rA);	// intersection A
	else veccopy(rb,rA);
	
	Points2Line(r0,Focus2,&a,&b);	// line P-F2
	LineEllipseIntersect(a,b,ra,rb);	// two intersections
	if(distance(r0,ra)<distance(r0,rb)) veccopy(ra,rB);	// intersection B
	else veccopy(rb,rB);
	
	Points2Line(rA,Focus2,&a1,&b1);	// line A-F2
	Points2Line(rB,Focus1,&a2,&b2);	// line B-F1
	LineLineIntersect(a1,b1,a2,b2,rC);	// point C
	
	vecsub(r0,rC,nr);	// normal is roughly along C-P
	normalize(nr,nr);
	if(pow(r0[0],2)/Ra2+pow(r0[1],2)/Rb2<1.0) vecprod(nr,-1.0,nr);	// if P is inside the ellipse
	
	c=1.0/sqrt(Ra2*nr[0]*nr[0]+Rb2*nr[1]*nr[1]);
	r1[0]=c*Ra2*nr[0];	// r1-r0 || nr
	r1[1]=c*Rb2*nr[1];
}


double getDistance2Bead(double r[2])	// given r in bead frame, find distance from r to bead surface
{
	double rr[2], nr[2];
	ProjectBeadNormal(r, rr, nr);
	return distance(r, rr);
}


int NodeInContactRegion(double r[2])	// r is in bead frame
{
	if(pow(r[0],2)/Ragrow2+pow(r[1],2)/Rbgrow2<=1) return 1;
	else return 0;
}

int NodeInBranchRegion(double r[2])	// r is in bead frame
{
	if(pow(r[0],2)/Rabranch2+pow(r[1],2)/Rbbranch2<=1) return 1;
	else return 0;
}


int NodeOnBead(double r[2])
{
	double x;
	x=pow(r[0],2)/Ra2+pow(r[1],2)/Rb2;
	if(x>0.9999 && x<1.0001) return 1;
	else return 0;
}


//--- autocatalytic around the bead ---

double getEllipLenX(double x)	// given 0<=x<=a, find l measured from x=a
{
	double x1, x2, f1, f2, z;

	if(x==0.0) return Circumquad;
	if(x==Ra) return 0.0;

	if(x>Ra) x=Ra;
	else if(x<-Ra) x=-Ra;
	x1=x;
	x2=x1*x1;

	if(Ra>=Rb) {
		f1=sqrt((Ra4+Rb2mRa2*x2))/Ra;
		f2=sqrt(1+Rb2mRa2*x2/Ra4);
		z=f1/f2*elle(asin(x1/Ra), ecc);	// this is measured from x=0, not x=a
		z=Circumquad-z;
	}
	else {	// swap x & y
		x1=Rb*sqrt(1-x2/Ra2);	// this is the 'y'
		x1=min2(x1, Rb);
		x2=x1*x1;
		f1=sqrt((Rb4+Ra2mRb2*x2))/Rb;
		f2=sqrt(1+Ra2mRb2*x2/Rb4);
		z=f1/f2*elle(asin(x1/Rb), ecc);	// this is measured from x=0, not x=a
	}	
	return max2(min2(z, Circumquad), 0.0);
}


double EllipLenDiff(double x, double len)
{
	return getEllipLenX(x)-len;
}


void prepZone(void)	// prepare bead zones, -Pi<zoneAng<=Pi in bead frame
{
	int i;
	double da, len, r[2];

	if(Ra==Rb) {
		da=Pidb/BeadZones;
		for(i=0; i<=BeadZoneshalf; i++) zoneAng[i]=i*da;
		for(i=BeadZoneshalfp1; i<BeadZones; i++) zoneAng[i]=-zoneAng[BeadZones-i];
	}
	else {
		zoneAng[0]=0.0;
		for(i=1; i<BeadZonesquad; i++) {
			len=max2(Circumquad-i*zonedL, 0);	// len is measured from x=a to 0<x<a
			r[0]=zbrent2(EllipLenDiff, len, 0, Ra, 1.0e-5);
			r[1]=Rb*sqrt(1.0-min2(pow(r[0],2)/Ra2,1.0));
			Crt2LabPol(r, &zoneAng[i]);	// -pi<Ang<=pi, but now only the 1st quadrant
		}
		zoneAng[BeadZonesquad]=Pihalf;
		for(i=BeadZonesquad+1; i<BeadZoneshalf; i++) {
			zoneAng[i]=Pi-zoneAng[BeadZoneshalf-i];
		}
		zoneAng[BeadZoneshalf]=Pi;
		for(i=BeadZoneshalf+1; i<BeadZones; i++) {
			zoneAng[i]=-zoneAng[BeadZones-i];
		}
	}
}


void prepSurfBin(void)	// prepare bead bins, -Pi<surfbinAng<=Pi in bead frame
{
	int i;
	double da, len, r[2];

	if(Ra==Rb) {
		da=Pidb/SurfBins;
		for(i=0; i<=SurfBinshalf; i++) surfbinAng[i]=i*da;
		for(i=SurfBinshalfp1; i<SurfBins; i++) surfbinAng[i]=-surfbinAng[SurfBins-i];
	}
	else {
		surfbinAng[0]=0.0;
		for(i=1; i<SurfBinsquad; i++) {
			len=max2(Circumquad-i*surfbindL, 0);	// len is measured from x=a to 0<x<a
			r[0]=zbrent2(EllipLenDiff, len, 0, Ra, 1.0e-5);
			r[1]=Rb*sqrt(1.0-min2(pow(r[0],2)/Ra2,1.0));
			Crt2LabPol(r, &surfbinAng[i]);	// -pi<Ang<=pi, but now only the 1st quadrant
		}
		surfbinAng[SurfBinsquad]=Pihalf;
		for(i=SurfBinsquad+1; i<SurfBinshalf; i++) {
			surfbinAng[i]=Pi-surfbinAng[SurfBinshalf-i];
		}
		surfbinAng[SurfBinshalf]=Pi;
		for(i=SurfBinshalf+1; i<SurfBins; i++) {
			surfbinAng[i]=-surfbinAng[SurfBins-i];
		}
	}
}
