
void FindConnectedNodes(int id)	// mark all nodes that are connected to node-id on top
{
	int i, loop, ix, ia, ib, nconnect, *iconnect;
	graph_node *p, *q;
	
	p = graph[id];
	p->connected = 1;
	
	if(p->nnbr <1) return;

	nconnect=0;
	iconnect=malloc(Nnodes*sizeof(int));
	for(i=0; i<Nnodes; i++) iconnect[i]=-1;
	
	ia=ib=0;
	p = p->next;
	while(p) {	// including id itself
		q = graph[p->id];	// only update the value of connected in the head node
		if(q->connected == 0) {
			q->connected = 1;
			iconnect[nconnect] = p->id;
			nconnect++;
		}
		p = p->next;
	}
	ib=nconnect;
	
	for(loop=0; loop<Nnodes; loop++) {
		for(ix=ia; ix<ib; ix++) {
			p = graph[iconnect[ix]]->next;
			while(p) {
				q = graph[p->id];	// only update the value of connected in the head node
				if(q->connected == 0) {
					q->connected = 1;
					iconnect[nconnect] = p->id;
					nconnect++;
				}
				p = p->next;
			}
		}
		ia=ib;
		ib=nconnect;
	}
	free(iconnect);
}



void CheckConnectivity(void)	// update the p->connected values
{
	int i;
	graph_node *p;

	for(i=0; i<Nnodes; i++) graph[i]->connected = 0;

	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->contact) FindConnectedNodes(i);	// mark all nodes that are connected to bead
	}
}


int findnodeindex(int id, int nodes[], int n)
{
	int i;
	i=0;
	while(nodes[i]!=id && i<n) i++;
	if(i<n) return i;
	else return -1;
}


void buildmatrix(double **m, int nodes[], int n)
{	// 2D matrix m[1...N][1...N]
	int i, j, k;
	graph_node *p;
	
	for(i=1; i<=n; i++) {
		for(j=1; j<=n; j++) m[i][j]=0.0;
		p=graph[nodes[i-1]];
		m[i][i]=max2(p->nnbr,1);	// nnbr=0 will give trouble
		p = p->next;
		while(p) {	// i's neighbors are marked with -1
			k = findnodeindex(p->id, nodes, n);
			if(k<0) {printf("\nerror in buidmatrix\n"); exit(0);}
			m[i][k]=-1.0;
			p = p->next;
		}
	}
}


void buildvector(double *bx, double *by, int nodes[], int n)
{	// vector bx[1...N], by[1...N]
	int i;
	graph_node *p;
	
	for(i=1; i<=n; i++) {
		p = graph[nodes[i-1]];
		bx[i] = p->DLvec[0];
		by[i] = p->DLvec[1];
	}
}


void SolveRelaxation(void)
{
	int i, j, n, maxdim, iter;
	int *nodes;
	unsigned long *mija;
	double **m, *msa, *bx, *by, *vdx, *vdy, err1, err2, err;
	double r[2];
	graph_node *p;
	
	if(Ncontact<1) return;
	
	n=0;
	for(i=0; i<Nnodes; i++) {
		if(graph[i]->connected) n++;
	}
	
	nodes=malloc(n*sizeof(int));
	
	j=0;
	for(i=0; i<Nnodes; i++) {
		if(graph[i]->connected) nodes[j++]=i;	// this stores the id of connected nodes
	}
	
	maxdim=n*max2(LinkPerNode,3)+n+1;	// dimension of mija[] and msa[]
	maxdim*=2;	// why above alone is not working???
	
	m=dmatrix(1,n,1,n);
	mija=lvector(1,maxdim);
	msa=dvector(1,maxdim);
	
	bx=dvector(1,n);
	by=dvector(1,n);
	vdx=dvector(1,n);
	vdy=dvector(1,n);
	
	buildmatrix(m, nodes, n);
	buildvector(bx, by, nodes, n);
	dsprsin(m, n, Matrix_TOL, maxdim, msa, mija);
	for(i=1; i<=n; i++) vdx[i]=vdy[i]=0.0;
	
	linbcg(msa, mija, n, bx, vdx, Matrix_ITOL, Matrix_TOL, Matrix_ITMAX, &iter, &err1);
	linbcg(msa, mija, n, by, vdy, Matrix_ITOL, Matrix_TOL, Matrix_ITMAX, &iter, &err2);
	
	err=err1+err2;
	if(err>=0.0 && err<1.0e-3) {	// sometimes the errors are huge or -inf!
		for(i=1; i<=n; i++) {
			p=graph[nodes[i-1]];
			r[0]=vdx[i];
			r[1]=vdy[i];
			limitvector(r,v0dt);	// s.t. the displacement is smaller than 5nm
			vdx[i]=r[0];
			vdy[i]=r[1];
			
			if(p->contact) {
				p->R0[0] += vdx[i];
				if(!(p->attached && LPD_CT==0)) p->R1[0] += vdx[i];	// R1[1] does not change
				p->Rtip[0] += vdx[i];
				p->R0[1] += vdy[i];
				p->Rtip[1] += vdy[i];
			}
		}
		
		for(i=0; i<n; i++) {
			p = graph[i]->next;
			while(p) {
				veccopy(graph[p->id]->R0, p->R0);
				p = p->next;
			}
		}
	}
	
	free(nodes);
	free_dmatrix(m,1,Nnodes,1,Nnodes);
	free_lvector(mija,1,maxdim);
	free_dvector(msa,1,maxdim);
	
	free_dvector(bx,1,Nnodes);
	free_dvector(by,1,Nnodes);
	free_dvector(vdx,1,Nnodes);
	free_dvector(vdy,1,Nnodes);
}


