
void CopyGraphNode(graph_node *p1, graph_node *p2)
{
	p2->id = p1->id;
	p2->bnd = p1->bnd;
	p2->nnbr = p1->nnbr;
	p2->contact = p1->contact;
	
	p2->tipcontact = p1->tipcontact;
	p2->arp23 = p1->arp23;
	p2->attached = p1->attached;
	p2->branchable = p1->branchable;
	p2->capped = p1->capped;
	
	p2->connected = p1->connected;
	p2->segmentid = p1->segmentid;
	p2->linkup = p1->linkup;
	p2->linkdown = p1->linkdown;
	
	p2->len = p1->len;
	p2->len0 = p1->len0;
	p2->dlen = p1->dlen;
	p2->l0 = p1->l0;
	p2->dl = p1->dl;
	
	veccopy(p1->R0, p2->R0);
	veccopy(p1->R1, p2->R1);
	veccopy(p1->r0, p2->r0);
	veccopy(p1->r1, p2->r1);
	veccopy(p1->nrm, p2->nrm);
	veccopy(p1->dlvec, p2->dlvec);
	veccopy(p1->DLvec, p2->DLvec);
	
	veccopy(p1->ftip, p2->ftip);
	veccopy(p1->Ftip, p2->Ftip);
	veccopy(p1->Rtip, p2->Rtip);
	
	p2->sumka = p1->sumka;
	p2->sumkc = p1->sumkc;
	p2->sumkd = p1->sumkd;
	
	p2->next = p1->next;
}


void SwapGraphNodes(graph_node *p1, graph_node *p2)
{
	graph_node *p;
	p=(graph_node *)malloc(sizeof(graph_node));
	CopyGraphNode(p1,p);
	CopyGraphNode(p2,p1);
	CopyGraphNode(p,p2);
	free(p);
}


void GetNewNodePos(double R0[2])	// rlab is in lab frame
{
#if TSTGEL	// ----- testing gel -----
	#if INBEAD
		double a, r, sn, cs;
		a=Pi*ran2(&mseed);
		sn=sin(a);
		cs=cos(a);
		if(Ra==Rb) r=Ra;
		else r=1.0/sqrt(cs*cs/Ra2+sn*sn/Rb2);
		r+=ran2(&mseed)*newnodedistance;
		R0[0]=Rcenter[0]+r*cs;
		R0[1]=Rcenter[1]-r*sn;
	#else
		R0[0]=toppos[0]+GelWidthIni*(1.0-2*ran2(&mseed));
		R0[1]=toppos[1]-ran2(&mseed)*newnodedistance;
	#endif

#else	// ----- not testing gel -----
	double rloc[2];
	#if INBEAD
		double a;
		double y, y2, rho, rhoy;
		
		if(Ra==Rb) {	// circle
			a=Pidb*ran2(&mseed);
			rloc[0]=Ra*cos(a);
			rloc[1]=Ra*sin(a);
		}
		else {	// 2D ellipse
			do {
				y=Rb*(1.0-2*ran2(&mseed));
				y2=y*y;
				rhoy=sqrt(1+Ra2_Rb2*y2/max2(eps,Rb2-y2));	// see notebook
				rho=rhoymax*ran2(&mseed);
			} while(rho>rhoy);
			rloc[0]=randsign()*Ra*sqrt(1-y2/Rb2);
			rloc[1]=y;
		}
		Loc2Lab(rloc, R0);	// first rotate
		vecadd(R0, Rcenter, R0);	// then translate
	#else
		#if CIRBND
		double x, y, z;
		do {
			x=NtwkRadius*(1.0-2*ran2(&mseed));
			y=NtwkRadius*(1.0-2*ran2(&mseed));
			z=x*x+y*y;
		} while(z>NtwkRadius2);
		rloc[0]=x;
		rloc[1]=y;
		#else
		rloc[0]=GelWidthIni*(1.0-2*ran2(&mseed));
		rloc[1]=GelHeightIni*(1.0-2*ran2(&mseed));
		#endif
		veccopy(rloc, R0);
	#endif

#endif	// -----
}


void GetNeighborPos(double r[2], int idx[], int *nx)	// r is in lab
{
	int i, j, k, cnt, nmax, flg;
	int idxplus[LinkPerNodeplus], idxplusflag[LinkPerNodeplus];
	double rtmp, rmin[LinkPerNodeplus], dotpd;
	double r1[2], r2[2], n1[2], n2[2];
	graph_node *p;

	for(i=0; i<LinkPerNodeplus; i++) {
		rmin[i]=inf;
		idxplus[i]=idxplusflag[i]=0;
	}
	
	cnt=0;
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		rtmp=distance(r,p->R0);
		
		flg=0;
		if(rtmp>0.05 && rtmp<0.8 && rtmp<rmin[LinkPerNodeplusm1] && 
			p->nnbr<LinkPerNodedb) flg=1;
	#if INBEAD
		if(flg) {
			if(CutOffBead(r,p->R0)) flg=0;
		}
	#endif
			
		if(flg) {
			j=LinkPerNodeplusm1;
			while(rtmp<rmin[j] && j>0) j--;
			if(j>0 && rtmp>rmin[j]) j++;
			for(k=LinkPerNodeplusm1; k>j; k--) {	// move the rest
				rmin[k]=rmin[k-1];
				idxplus[k]=idxplus[k-1];
			}
			rmin[j]=rtmp;
			idxplus[j] = p->id;
			cnt++;
		}
	}
	
	for(i=0; i<LinkPerNode; i++) idx[i]=idxplus[i];	// temporarily accept it
	
	if(cnt<LinkPerNode) {	// not enough nodes selected
		*nx=cnt;
		return;
	}
	
	nmax=min2(cnt, LinkPerNodeplus);	// cnt may < or > LinkPerNodeplus
	*nx=k=1;	// fix idx[0]=idxplus[0]
	idxplusflag[0]=1;
	for(i=0; i<LinkPerNodem1; i++) {	// among LinkPerNodeplus, pick out LinkPerNode nodes
		vecsub(r, graph[idxplus[i]]->R0, r1);
		normalize(r1, n1);
		j=i;
		do {
			j++;
			vecsub(r, graph[idxplus[j]]->R0, r2);
			normalize(r2,n2);
			dotpd=fabs(dotprod(n1,n2));
		} while(dotpd>0.9 && idxplusflag[j]==1 && j<nmax);	// shouldn't be too close
		
		if(j<nmax && k<LinkPerNode) {
			idx[k]=idxplus[j];
			idxplusflag[j]=1;	// this node is now taken
			k++;
			(*nx)++;
		}
	}
}


void GetNeighborPos2(double rloc[2], double r[2], int idx[], int *nx)	// r is in lab
{
	int i, j, k, cnt, nmax;
	int idxplus[LinkPerNodeplus], idxplusflag[LinkPerNodeplus];
	double nrm[2], drlab[2], prod;
	double rtmp, rmin[LinkPerNodeplus], dotpd;
	double r1[2], r2[2], n1[2], n2[2];
	graph_node *p;

	for(i=0; i<LinkPerNodeplus; i++) {
		rmin[i]=inf;
		idxplus[i]=idxplusflag[i]=0;
	}
	nrm[0]=rloc[0]/Ra2;
	nrm[1]=rloc[1]/Rb2;
	Loc2Lab(nrm, nrm);	// surface outward-normal direction in lab frame
	
	cnt=0;
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		
		rtmp=distance(r, p->R0);
		vecsub(p->R0, r, drlab);
		prod=dotprod(nrm, drlab);	// if new node is above horizon, then prod>=0, otherwise<0
		
		if(rtmp>0.05 && rtmp<Rafix && prod>=0.0 && rtmp<rmin[LinkPerNodeplusm1]) {
			j=LinkPerNodeplusm1;
			while(rtmp<rmin[j] && j>0) j--;
			if(j>0 && rtmp>rmin[j]) j++;
			for(k=LinkPerNodeplusm1; k>j; k--) {	// move the rest
				rmin[k]=rmin[k-1];
				idxplus[k]=idxplus[k-1];
			}
			rmin[j]=rtmp;
			idxplus[j] = p->id;
			cnt++;

		}	// end of if
	}	// end of i
	
	for(i=0; i<LinkPerNode; i++) idx[i]=idxplus[i];	// temporarily accept it

	if(cnt<LinkPerNode) {	// not enough nodes selected
		*nx=cnt;
		return;
	}
	
	nmax=min2(cnt, LinkPerNodeplus);	// cnt may < or > LinkPerNodeplus
	*nx=k=1;	// fix idx[0]=idxplus[0]
	idxplusflag[0]=1;
	for(i=0; i<LinkPerNodem1; i++) {	// among LinkPerNodeplus, pick out LinkPerNode nodes
		vecsub(r, graph[idxplus[i]]->R0, r1);
		normalize(r1, n1);
		j=i;
		do {
			j++;
			vecsub(r, graph[idxplus[j]]->R0, r2);
			normalize(r2,n2);
			dotpd=fabs(dotprod(n1,n2));
		} while(dotpd>0.9 && idxplusflag[j]==1 && j<nmax);	// shouldn't be too close
		
		if(j<nmax && k<LinkPerNode) {
			idx[k]=idxplus[j];
			idxplusflag[j]=1;	// this node is now taken
			k++;
			(*nx)++;
		}
	}
}


void appendNode(graph_node *p, int id)	// append node id to thread p
{
	graph_node *q, *r;
	
	if(!p) printf("error\n");
	q = p;
	while(q->next) q = q->next;	// q is the end of p
	
	r = (graph_node *)malloc(sizeof(graph_node));
	q->next = r;
	
	CopyGraphNode(graph[id], r);
	r->l0 = distance(p->R0, r->R0);
	r->dl = 0.0;
	r->next = NULL;
}


void GetNewNodeProp(graph_node *p)	// get new node's properties, input is p->R0
{
#if TSTGEL
	getLocalPropsTest(p,1);	// from R0, get r0, r1, nrm, R1 & Rtip
#else
	getLocalProps(p,1);	// from R0, get r0, r1, nrm, R1 & Rtip
#endif
	veccopy(p->R1, p->Rtip);
	
	p->contact = 1;
	p->len = p->len0 = distance(p->r0, p->r1);	// initial filament length
	p->dlen = 0.0;
	
#if NEWATT
	if(ran2(&mseed)<probnewatt) p->attached = 1;
	else p->attached = 0;
#else
	p->attached = 0;
#endif
	
	p->l0 = 0.0;	// itself
	p->dl = 0.0;
	
	veczero(p->dlvec);
	veczero(p->DLvec);

#if LMT_NF
	if(Nfila>=Nfilamax) p->capped = 1;	// if limit max fila number
	else p->capped = 0;
#else
	p->capped = 0;
#endif
	
	p->sumka = 0.5*(1-2*ran2(&mseed));	// stochastic
	p->sumkc = 0.1*(1-2*ran2(&mseed));
	p->sumkd = 0.5*(1-2*ran2(&mseed));
	
	p->next = NULL;
	

#if TSTGEL
	#if INBEAD
		if(NodeInContactRegion(p->r0)) p->bnd = 1;
		else if(p->R0[1] < botlayercontact) p->bnd = -1;
		else p->bnd = 0;
	#else
		if(p->R0[1]>toppos[1]-toplayerthick) p->bnd = 1;
		else if(p->R0[1] < botlayercontact) p->bnd = -1;
		else p->bnd = 0;
	#endif
#endif
	
}

//--- nucleation ---

void NodeCreationNuc(void)	// create 1 node and connect to other nodes, append to graph
{
	int i, nm, nx;
	int idx[LinkPerNode];
	double R0[2];
	graph_node *p;

	if(Nnodes>Nnodes_max) { printf("Too many nodes.\n"); exit(0); }
	
	GetNewNodePos(R0);	// new node's id=nm, append to the list
	GetNeighborPos(R0, idx, &nx);	// nx neighbors
	
	nm=Nnodes;
	Nnodes++;
	Ncontact++;
	
	insertEdge(graph+nm, nm);	// add nm to the head of graph[nm], self as 1st column'
	p=graph[nm];
	p->id = nm;
	p->nnbr = nx;
	
	veccopy(R0, p->R0);
	GetNewNodeProp(p);	// input p->R0, get other initial properties

#if TSTGEL
	#if INBEAD
		if(NodeInContactRegion(p->r0)) ntop++;
		else if(p->R0[1] < botlayercontact) nbot++;
	#else
		if(p->R0[1]>toppos[1]-toplayerthick) ntop++;
		else if(p->R0[1] < botlayercontact) nbot++;
	#endif
#endif
	
	ntop=max2(ntop,1);
	nbot=max2(nbot,1);
	
	for(i=0; i<nx; i++) {	// for each neighbor
		appendNode(graph[nm], idx[i]);	// append idx[i] to thread graph[nm]
		appendNode(graph[idx[i]], nm);	// append nm to thread graph[idx[i]]
		(graph[idx[i]]->nnbr)++;	// update neighbor counter
	}
}


//--- autocatalytic ---

void CreateNewNodeInZone(int z)	// create new node near zone-z
{
	int i, nm, nx;
	int idx[LinkPerNode];
	double a1, a2, a, r, sa, ca;
	double rloc[2], rlab[2];
	graph_node *p;
	
	if(Ra==Rb) {	// circle
		a=Pidb*ran2(&mseed);
		sa=sin(a);
		ca=cos(a);
		rloc[0]=Ra*sa;
		rloc[1]=Ra*ca;
	}
	else {	// 2D ellipse
		if(z==0) {	// a=+0
			a1=zoneAng[BeadZonesm1];
			a2=zoneAng[1];
		}
		else if(z==BeadZonesm1) {	// a=-0
			a1=zoneAng[z-1];
			a2=0.0;
		}
		else {
			a1=zoneAng[z-1];
			a2=zoneAng[z+1];
			if(z==BeadZoneshalf || z==BeadZoneshalfp1) a2+=Pidb;
		}
		a=a1+ran2(&mseed)*(a2-a1);	//  a(z-1) < a < a(z+1)
		sa=sin(a);
		ca=cos(a);
	
		r=1.0/sqrt(sa*sa/Ra2+ca*ca/Rb2);
		rloc[0]=r*sa;
		rloc[1]=r*ca;
	}
	
	Loc2Lab(rloc, rlab);	// first rotate
	vecadd(rlab, Rcenter, rlab);	// then translate
	
#if INBEAD
	GetNeighborPos(rlab, idx, &nx);	// nx neighbors
#else
	GetNeighborPos(rlab, idx, &nx);	// nx neighbors
#endif
	
	nm=Nnodes;
	Nnodes++;
	
	insertEdge(graph+nm, nm);
	p=graph[nm];
	p->id = nm;
	p->nnbr = nx;
	
	veccopy(rlab, p->R0);
	GetNewNodeProp(p);	// input p->R0, get other initial properties
	
#if TSTGEL
	p->nrm[0] = 0.0;
	p->nrm[1] = -1.0;
	if(p->R0[1] > toppos[1]-toplayerthick) ntop++;
	else if(p->R0[1] < botlayercontact) nbot++;
#endif
	
	for(i=0; i<nx; i++) {	// for each neighbor
		appendNode(graph[nm], idx[i]);	// append idx[i] to thread graph[nm]
		appendNode(graph[idx[i]], nm);	// append nm to thread graph[idx[i]]
		(graph[idx[i]]->nnbr)++;	// update neighbor counter
	}
}


int widenz(int z)
{
	int zz;
	
	zz=(int)(z+SpreadWhalf*(1.0-2*ran2(&mseed))+0.5);	// +0.5 is a must, otherwise biased
	if(zz<0) zz+=BeadZones;
	else if(zz>=BeadZones) zz-=BeadZones;
	return zz;
}


void NodeCreationAut(int n)	// create n nodes according to autocatalytic rules
{
	int i, j, z, ntot, np[BeadZones];
	double a;
	graph_node *p;
	
	if(Nnodes>Nnodes_max) { printf("Too many nodes.\n"); exit(0); }
	
	ntot=0;
	for(i=0; i<BeadZones; i++) np[i]=0;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(NodeInBranchRegion(p->r0)) {	// base is within branching region, not tip (p->r1)
			ntot++;
			Crt2LabPol(p->r0, &a);	// -pi<a<=pi, note that p->r1 may not be updated yet
			if(a>=0.0) {
				j=0;
				while(a>=zoneAng[j] && j<BeadZoneshalf) j++;
				if(j>0) j--;
			}
			else {
				if(a>=zoneAng[BeadZonesm1]) j=BeadZonesm1;
				else if(a<=zoneAng[BeadZoneshalfp1]) j=BeadZoneshalf;
				else {
					j=BeadZoneshalfp1;
					while(a>=zoneAng[j] && j<BeadZonesm1) j++;
					if(j>BeadZoneshalfp1) j--;
				}
			}
			if(ran2(&mseed)>0.5) j++;
			if(j>BeadZonesm1) j=0;

			np[j]++;
		}	// end of if
	}	// end of i
	
	for(i=1; i<BeadZones; i++) np[i]+=np[i-1];	// convert to cumulative sum
	for(i=0; i<n; i++) {	// based on density, find a random zone to create new node
		j=(int)(ntot*ran2(&mseed));
		z=0;
		while(j>=np[z] && z<BeadZones) z++;
		if(z>=BeadZones) z--;
		z=widenz(z);	// widen z, corresponding to widening of filaments
		CreateNewNodeInZone(z);
	}
}


void NodeDeletion(int id)	// remove id thread from the graph, replace it with the last thread
{
	int nm;
	graph_node *p, *q, *r;
	
	if(Nnodes<1) return;
	
	nm=Nnodes-1;
	Nnodes--;
	
	while(graph[id]) {
		p=graph[id];
		graph[id] = p->next;
		if(p->id != id) {
			q=graph[p->id];
			r = q->next;
			while(r) {
				if(r->id == id) {
					q->next = r->next;
					free(r);
					r = q->next;
					(graph[p->id]->nnbr)--;
				}
				else {
					q = r;
					r = r->next;
				}
			}
		}
		free(p);
	}	// now graph[id]=NULL

	if(id!=nm) {
		graph[id]=(graph_node *)malloc(sizeof(graph_node));
		CopyGraphNode(graph[nm],graph[id]);
		free(graph[nm]);	// only remove the head node of last thread
		
		p=graph[id];
		while(p) {
			if(p->id == nm) p->id = id;
			else {
				q = graph[p->id]->next;	// this thread contains node[id] (old node[nm])
				while(q) {
					if(q->id == nm) q->id = id;	// update id
					q = q->next;
				}
			}
			p = p->next;
		}
	}
}


void NodeDeletionRnd(void)	// remove 1 rnd. thread from the graph
{
	int id, cnt;
	
	if(Nnodes<1) return;
	
	cnt=0;
	id=(int)(ran2(&mseed)*Nnodes);
	while(graph[id]->contact && cnt<Nnodes) {	// remove a node not in contact with bead
		id++;
		if(id>=Nnodes) id=0;
		cnt++;
	}
	if(cnt==Nnodes) return;	// no nodes are ready for deletion
	
	NodeDeletion(id);
}


void NodeDeletionOrphan(void)	// remove orphan nodes
{
	int i, id, flg, go;
	graph_node *p;
	
	flg=1;
	while(flg) {
		go=1;
		i=Nnodes-1;
		while(i>=0 && go) {
			p=graph[i];
			if(p->nnbr <1) {id=i; go=0;}
			i--;
		}
		if(go==0) {NodeDeletion(id); flg=1;}	// now Nnodes changes
		else flg=0;
	}
}


void LinkRupture(void)
{
	int i;
	graph_node *p, *q, *r, *s;
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		q = p->next;
		while(q) {
			if(fabs(q->dl) > dlbr) {	// rupture if streched/compressed too much
				r=graph[q->id];	// go to the main node of q
				s = r->next;
				while(s) {
					if(s->id == i) {	// remove p from q-list
						r->next = s->next;
						free(s);
						s = r->next;
						(graph[q->id]->nnbr)--;
					}
					else {
						r = s;
						s = s->next;
					}
				}
				
				p->next = q->next;	// back to the current thread
				free(q);	// remove q from p-list
				q = p->next;
				(graph[i]->nnbr)--;	// update neighbor counter
			}
			else {
				p = q;
				q = q->next;
			}
		}
	}
}


void NodesDynamics(void)
{
	int i, n;
	
#if AUTNUC
	probaut+=kautdt;
	if(probaut>1.0) {
		n=(int)(probaut);
		NodeCreationAut(n);
		probaut-=n;
	}
#else
	probnuc+=knucdt;
	if(probnuc>1.0) {
		n=(int)(probnuc);
		for(i=0; i<n; i++) NodeCreationNuc();
		probnuc-=n;
	}
#endif

	probdis+=kdisdt*Nnotcontact;
	if(probdis>1.0) {
		n=(int)(probdis);
		for(i=0; i<n; i++) NodeDeletionRnd();
		probdis-=n;
	}

#if LNKBRK
	LinkRupture();
#endif

	NodeDeletionOrphan();
}


void NodesStats(void)
{
	int i;
	graph_node *q;

	Nlinks=0;
	linklenave=0.0;
	for(i=0; i<Nnodes; i++) {
		Nlinks += graph[i]->nnbr;
		q=graph[i]->next;
		while(q) {
			linklenave += q->l0;
			q = q->next;
		}
	}
	Nlinks/=2;
	linklenave/=2*Nlinks;
	Nlinkpernode=(float) (1.0*Nlinks/max2(Nnodes,1));
}
