
void FindConnectedNodes(int id)	// mark all nodes that are connected to node-id on top
{
	int i, loop, ix, ia, ib, nconnect, *iconnect;
	graph_node *p, *q;
	
	p = graph[id];
	p->connected = 1;
	
	if(p->nnbr <1) return;

	nconnect=0;
	iconnect=malloc(Nnodes*sizeof(int));
	for(i=0; i<Nnodes; i++) iconnect[i]=-1;
	
	ia=ib=0;
	p = p->next;
	while(p) {
		q = graph[p->id];
		if(q->connected == 0) {
			q->connected = 1;
			iconnect[nconnect] = p->id;
			nconnect++;
		}
		p = p->next;
	}
	ib=nconnect;
	
	for(loop=0; loop<Nnodes; loop++) {
		for(ix=ia; ix<ib; ix++) {
			p = graph[iconnect[ix]]->next;
			while(p) {
				q = graph[p->id];
				if(q->connected == 0) {
					q->connected = 1;
					iconnect[nconnect] = p->id;
					nconnect++;
				}
				p = p->next;
			}
		}
		ia=ib;
		ib=nconnect;
	}
	free(iconnect);
}



void CheckConnectivity(void)	// update the p->connected values
{
	int i;
	graph_node *p;

	node_ymin=inf;
	node_ymax=-inf;
	for(i=0; i<Nnodes; i++) graph[i]->connected = 0;

	for(i=0; i<Nnodes; i++) {
		p=graph[i];
	#if INBEAD
		if(p->contact) FindConnectedNodes(i);	// mark all nodes that are connected to top
	#else
		if(p->contact || toppos[1] - p->R0[1] <toplayerthick) FindConnectedNodes(i);
		if(p->R0[1] > node_ymax) node_ymax = p->R0[1];
	#endif
	}
	
#if INBEAD
	node_ymax=fabs(Rcenter[1]-Rmax);	// from bottom of the bead
#endif

	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->connected) {	// after connection is established
			if(p->R0[1] < node_ymin) node_ymin = p->R0[1];
		}
	}

	node_ymax+=eps;
	node_ymin-=eps;
}


void DivideSegments(void)
{
	int i, j, k, flg;
	double dy;
	graph_node *p, *q;

	dy=(node_ymax-node_ymin)/CoarseSegment;

	for(i=0; i<CoarseSegment; i++) SegmentNodesCount[i]=0;
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		p->segmentid = -1;
		
		if(p->connected) {
	#if INBEAD
		if(p->R0[1]>node_ymax) p->segmentid = -2;	// ignore those near the bead
		else {
	#endif
			j = (int)((node_ymax - p->R0[1])/dy);	// segmentid: top=0, bot=CoarseSegmentm1
			j = min2(max2(j,0), CoarseSegmentm1);
			p->segmentid = j;
			SegmentNodesCount[j]++;
		}
	#if INBEAD
		}
	#endif
	}
	
	// for each segment, record which nodes are inside
	for(i=0; i<CoarseSegment; i++) {
		k=0;
		for(j=0; j<Nnodes; j++) {
			p=graph[j];
			if(p->connected && p->segmentid == i) {
				SegmentNodeArray[i][k] = p->id;
				k++;
			}
		}
	}
	// in each segment, find nodes that are connected to lower segments
	for(i=0; i<CoarseSegmentm1; i++) {	// ignore the bottom segment
		for(j=0; j<SegmentNodesCount[i]; j++) {	// for each node in segment-i
			p = graph[SegmentNodeArray[i][j]];
			q = p->next;
			flg=0;
			while(q && !flg) {	// flg=1 if this neighbor node's segment is below
				if(graph[q->id]->segmentid > i) flg=1;	// note that only head node has segmentid updated
				q = q->next;
			}
			p->linkdown = flg;	// p->linkdown = 1 if p is connected to lower segments
		}
	}
}


void MoveSegments1(void)	// updates p->R0 based on force balance in each segment
{
	int i, j, nlink;
	double f, dLi[2], dy[CoarseSegment], sumdy;
	graph_node *p, *q;

	i=0;
	nlink=0;
	f=0.0;
	for(j=0; j<SegmentNodesCount[i]; j++) {	// for each node in segment
		p = graph[SegmentNodeArray[i][j]];
		if(p->linkup) {
			nlink++;
			f += -(p->Ftip[1]);	// force on filament
		}
	}	// end of j-loop
	if(nlink==0) dy[i]=0.0;
	else dy[i]=(f-Fext[1])/nlink;
	
	for(i=1; i<CoarseSegment; i++) {	// for each segment except the top one
		f=0.0;
		nlink=0;
		for(j=0; j<SegmentNodesCount[i]; j++) {	// for each node in segment
			p = graph[SegmentNodeArray[i][j]];
			if(p->linkup) {	// if this node links to an upper segment
				q = p->next;
				while(q) {
					if(graph[q->id]->segmentid < i) {	// q is in an upper segment
						nlink++;
						getdli(p->R0, q->R0, q->l0, &(q->dl), dLi);
						f += dLi[1];	// f is the force exerted from upper segment, + is up
					}
					q = q->next;
				}
			}	// end of if(p->linkup)
		}	// end of j-loop
		
		if(nlink==0) dy[i]=0.0;	// movement=0 if no connections in this segment
		else dy[i]=(f-Fext[1])/nlink;
	}	// end of i-loop
	
	dy[0]=0.0;	// don't move the top segment, let whole-gel-move deal with it
	
	// do the movement
	sumdy=0.0;
	for(i=0; i<CoarseSegment; i++) {	// segments from bottom to top
		sumdy += dy[i];
		for(j=0; j<SegmentNodesCount[i]; j++) {
			p = graph[SegmentNodeArray[i][j]];
			if(p->linkup) {
				p->R0[1] += sumdy;	// only move nodes that link down
				p->Rtip[1] += sumdy;
			}
		}
	}
	
#if INBEAD
	for(i=0; i<Nnodes; i++) {	// top cusp around the bead
		if(p->segmentid == -2) {
			p->R0[1] += sumdy;
			p->Rtip[1] += sumdy;
		}
	}
#endif

	toppos[1]+=sumdy;
	dtoppostot[1]+=sumdy;
	Rcenter[1]=toppos[1];
}


// linkdown
void MoveSegments2(void)	// updates p->R0 based on force balance in each segment
{
	int i, j, nlink;
	double f, dLi[2], dy[CoarseSegment], sumdy;
	graph_node *p, *q;

	for(i=0; i<CoarseSegmentm1; i++) {	// for each segment except the bottom one
		f=0.0;
		nlink=0;
		for(j=0; j<SegmentNodesCount[i]; j++) {	// for each node in segment
			p = graph[SegmentNodeArray[i][j]];
			if(p->linkdown) {	// if this node links to a bottom segment
				q = p->next;
				while(q) {
					if(graph[q->id]->segmentid > i) {	// q is in a lower segment
						nlink++;
						getdli(p->R0, q->R0, q->l0, &(q->dl), dLi);
						f += dLi[1];	// f is the force exerted from lower segment, + is up
					}
					q = q->next;
				}
			}	// end of if(p->linkdown)
		}	// end of j-loop
		
		if(nlink==0) dy[i]=0.0;	// movement=0 if no connections in this segment
	}	// end of i-loop
	
	dy[CoarseSegmentm1]=(Fbot[1]+Fext[1])/ksnode/2.0;	// denominator is nbot, guess 2
	dy[CoarseSegmentm1]=min2(max2(dy[CoarseSegmentm1],-v0dt), v0dt);

	sumdy=0.0;
	for(i=CoarseSegmentm1; i>=0; i--) {	// segments from bottom to top
		sumdy += dy[i];
		for(j=0; j<SegmentNodesCount[i]; j++) {
			p = graph[SegmentNodeArray[i][j]];
			p->R0[1] += sumdy;	// move all nodes in segment
			p->Rtip[1] += sumdy;
		}
	}
	
#if INBEAD
	for(i=0; i<Nnodes; i++) {	// top cusp around the bead
		if(p->segmentid == -2) {
			p->R0[1] += sumdy;
			p->Rtip[1] += sumdy;
		}
	}
#endif

	toppos[1]+=sumdy;
	dtoppostot[1]+=sumdy;
	Rcenter[1]=toppos[1];
}



void CoarseGrainMotion(void)
{
#if TSTGEL
	#if INBEAD
	if(Rcenter[1]-botpos[1]<1*Rmax) return;	// bead is too close to bottom, don't use coarse
	#else
	if(toppos[1]-botpos[1]<2.5*GelHeightIni) return;	// plate is too close to bottom, don't use coarse
	#endif
#endif

	DivideSegments();
	MoveSegments2();	// from bottom to top, better than top to bottom
}



//----- gel move as a whole -----

void WholeGelMotion(void)
{
	int i, j;
	double dr[2], f[2], dy0;	//, ylow;
	double h, kntop, knbot;
	double ylow;
	graph_node *p, *q;
	
	ntop=nbot=0;
	veczero(dr);
	ylow=toppos[1];
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->connected) {
			if(p->contact && p->capped==0) ntop++;
			else if(p->R0[1] <= dlt) nbot++;
			if(p->R0[1] < ylow) ylow = p->R0[1];	// position of the lowest node
		}
	}
#if INBEAD
	ntop/=Pihalf;	// projection of bead surface
#endif
	ntop=max2(ntop,2);
	nbot=max2(nbot,2);
	
	
	vecadd(Fext, Fbot, Fgel);	// Ftop & Fbot are obtained from GelMove(), measured with ks_node

	veccopy(Fgel, f);
	
	if(f[1]<0) {	// top plate push gel down
		dy0=f[1]*ksnode_fila/ntop;	// dy0>0, how far the gel wants to move downwards
		h=node_ymin-botpos[1];	// h>0 if the lowest node is above the bottom plate
		if(-dy0<=h) {	// not reaching bottom plate
		#if INBEAD
			dr[1]=dy0+f[1]*beadmjudtrelax;	// falling down speed is determined by force & viscous drag
		#else
			dr[1]=dy0+f[1]*platemjudtrelax;	// use 1e3 for our unrealistic parameters
		#endif
		}
		else {
			kntop=ksfila*ntop;
			knbot=ksnode*nbot;
			dr[1]=(kntop*dy0-knbot*h)/(kntop+knbot);
		}
	}
	else {	// bottom plate push gel up
		dy0=f[1]/nbot;	// dy0<0
		dr[1]=dy0;
	}
	
	limitvector(dr,v0dt);
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->connected && !(Fext[1]>0 && p->bnd == -1)) {
			vecadd(p->R0, dr, p->R0);
			vecadd(p->R1, dr, p->R1);
			vecadd(p->Rtip, dr, p->Rtip);
			
			for(j=0; j<Nnodes; j++) {	// update other nodes
				q = graph[j]->next;
				while(q) {
					if(q->id == i) veccopy(p->R0, q->R0);
					q = q->next;
				}
			}
		}
	}
	vecadd(toppos, dr, toppos);	// plate follows gel immediately
	vecadd(dtoppostot, dr, dtoppostot);
	veccopy(toppos, Rcenter);
}


