

void getvertexr(int i, int j, double r1[2], double r2[2])	// return vertices with id=i&j
{
	int flg=0;
	tVertex p;
	
	p=vertices;
	while(flg<2 && p) {
		if(i==p->vnum) { veccopy(p->v,r1); flg++; }
		if(j==p->vnum) { veccopy(p->v,r2); flg++; }
		p=p->next;
	}
}


int swapcomp(int p[2], int i, int j)
{
	if(p[0]==i && p[1]==j) return 1;
	if(p[0]==j && p[1]==i) return 1;
	return 0;
}


void addpair2list(int i, int j)
{
	graph_edge *p, *q;

	if(!myedge) {
		myedge=(graph_edge *)malloc(sizeof(graph_edge));
		myedge->pair[0]=i;
		myedge->pair[1]=j;
		myedge->next = NULL;
		graph_nedge++;
		return;
	}
	
	p=q=myedge;
	while(p && !swapcomp(p->pair, i, j)) {q=p; p=p->next;}
	if(!p) {
		p=(graph_edge *)malloc(sizeof(graph_edge));	// new pair
		p->pair[0]=i;
		p->pair[1]=j;
		p->next = NULL;	// add to the tail
		q->next = p;
		graph_nedge++;
	}
}


void addface2list(tFace p)	// get pairs from each face
{
	int i, j, id[3];
	double v[3][2];
	
	for(i=0; i<3; i++) {	// three vertices
		id[i] = p->vertex[i]->vnum;
		veccopy(p->vertex[i]->v, v[i]);
	}
	
	for(i=0; i<3; i++) {
		j=(i+1)%3;
	#if INBEAD
		if(!CutOffBead(v[i],v[j])) {	// extra requirements
			addpair2list(id[i],id[j]);
		}
	#else
		addpair2list(id[i],id[j]);
	#endif
	}
}


void getedgelist(void)	// get pairs from all faces
{
	tFace p;
	p=faces;
	if(p) do {
		if(p->lower) addface2list(p);
		p = p->next;
	} while(p!=faces);
}


void getpair_i(int i, int pair[2])
{
	int j=0;
	graph_edge *p;

	p=myedge;
	while(j++<i) p=p->next;
	pair[0] = p->pair[0];
	pair[1] = p->pair[1];
}


void insertEdge( graph_node **ptr, int id )	// insert a new graph_node at the start.
{
	graph_node *newnode = (graph_node *)malloc(sizeof(graph_node));
	newnode->id = id;
	newnode->next = *ptr;
	*ptr = newnode;
}


void GetGraph(void)	// fills graph as adjacency list from array edges.
{
	int i;
	int pair[2];
	for( i=0; i<graph_nedge; ++i ) {
		getpair_i(i, pair);
		insertEdge(graph+pair[0], pair[1]);
		insertEdge(graph+pair[1], pair[0]); // undirected graph.
	}
	for(i=0; i<Nnodes; i++) insertEdge(graph+i, i);
	for(i=Nnodes; i<Nnodes_max; i++) graph[i]=NULL;
}


void GetGraphProp(void)	// initial setup
{
	int i, id, cnt;
	tVertex v;
	graph_node *p, *q;
		
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		
		while(p) {
			id = p->id;
			v=vertices;
			while(v && v->vnum != id) v = v->next;
			if(v) veccopy(v->v, p->r0);
			else { printf("error in graph-prop.\n"); exit(0); }
			Loc2Lab(p->r0, p->R0);
			vecadd(p->R0, Rcenter, p->R0);
		#if TSTGEL
			getLocalPropsTest(p,1);
		#else
			getLocalProps(p,1);	// from R0, get r0, r1 & R1
		#endif
			veccopy(p->R1, p->Rtip);
			veczero(p->ftip);
			veczero(p->Ftip);
			
		#if TSTGEL
			p->nrm[0] = 0.0;
			p->nrm[1] = -1.0;
			if(p->R0[1]>toplayerheight) p->bnd=1;
			else if(p->R0[1]<-botlayerheight) p->bnd=-1;
			else p->bnd=0;
			
			if(p->R0[1]>toplayerheight) p->contact = 1;
			else p->contact = 0;
		#endif
			p = p->next;
		}
	}
	
	for(i=0; i<Nnodes; i++) {	// for each graph node, find initial rest length
		p = graph[i];
		q = p->next;
		
		if(ran2(&mseed)<probnewatt) {	// attached filament
			p->len = p->len0 = distance(p->r0, p->r1);	// initial filament length
			p->attached = p->contact;
		}
		else {	// free filament
			p->len = 0.0;
			p->len0 = distance(p->r0, p->r1);
			p->attached = 0;
		}
		
		p->l0 = 0.0;	// itself
		p->dl = p->dlen = 0.0;
		
		veczero(p->dlvec);
		veczero(p->DLvec);
		
		p->capped = 0;
		p->sumka = ran2(&mseed);	// stochastic
		p->sumkc = ran2(&mseed);
		p->sumkd = ran2(&mseed);
		
		cnt=0;	// neighbor counter
	#if TSTGEL
		if(p->R0[1]>toplayerheight) ntop++;
		else if(p->R0[1]<-toplayerheight) nbot++;
	#endif
	
		while(q) {
			q->l0 = distance(p->R0, q->R0);	// distance of graph[i][0] to graph[i][j]
			q->dl = 0.0;
			cnt++;
			q = q->next;
		}
		p->nnbr = cnt;
	#if !TSTGEL
		if(NodeInContactRegion(p->r0)) p->contact = 1;
		else p->contact = 0;
	#endif
	}
	
#if TSTGEL
	ntoplinks=LinkPerNode*ntop;
	if(ntop*nbot==0) { printf("Error: no top/bottom nodes.\n"); exit(0); }
#endif
}


void BuildGraph(void)
{
	graph = (graph_node **)calloc(Nnodes_max, sizeof(graph_node *));
	getedgelist();
	GetGraph();
	GetGraphProp();
}


void CleanGraph(void)
{
	int i;
	graph_edge *p;
	graph_node *q;
	
	while(myedge) {
		p=myedge;
		myedge = p->next;
		free(p);
	}
	myedge=NULL;

	if(graph) {
		for(i=Nnodes-1; i>=0; i--) {
			while(graph[i]) {
				q=graph[i];
				graph[i] = q->next;
				free(q);
			}
			free(graph[i]);
		}
		free(graph);
	}
	graph=NULL;
}


void CleanUp(void)
{
	CleanTriangles();
	CleanGraph();
#if VCDBUG
	_CrtDumpMemoryLeaks();
#endif
}
