
void makeTexImage(void) {
	int i, j, c;
	double r2;
    for (i = 0; i < TextureWidth; i++) {
        for (j = 0; j < TextureWidth; j++) {
						r2=pow(i-TextureHalfWidth,2)+pow(j-TextureHalfWidth,2);
						c=(int)(exp(-r2/TextureDecayWidth2db)*100);
						TexImage[i][j][0] = (GLubyte) c;
						TexImage[i][j][1] = (GLubyte) c;
						TexImage[i][j][2] = (GLubyte) c;
						TexImage[i][j][3] = (GLubyte) 50;	// alpha, smaller more transparent, max=255
        }
    }
}

void init_GL(void)
{
#if AALIAS
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_POLYGON_SMOOTH);
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	glHint(GL_LINE_SMOOTH_HINT, GL_DONT_CARE);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_DONT_CARE);
#endif

	glClear(GL_COLOR_BUFFER_BIT);
	if(texturemap==0) glClearColor(1.0, 1.0, 1.0, 1.0);
	else glClearColor(0.3, 0.3, 0.3, 1.0);

	if(texturemap==1) {
		glShadeModel(GL_FLAT);
		//glShadeModel(GL_SMOOTH);
		//glEnable(GL_DEPTH_TEST);
		makeTexImage();
		glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
		glGenTextures(1, &texName);
		glBindTexture(GL_TEXTURE_2D, texName);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

		//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
		//glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, TextureWidth,
			TextureWidth, 0, GL_RGBA, GL_UNSIGNED_BYTE, TexImage);
    }
    //else glDisable(GL_DEPTH_TEST);
    glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);
	glDisable(GL_LIGHT0);
	glClear(GL_COLOR_BUFFER_BIT);
	
}


void changeSize(int w, int h)
{
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(-1, 1, -1, 1);	// left, right, bottom, top
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}


void keyboard(unsigned char key, int x, int y)
{
	switch (key) {
		case 27:
			terminate();
			break;
		case 'r':
			CleanUp();
			reset();
			BuildNetwork();
			init_GL();
			break;
		case 'd':
			showlink=(showlink+1)%3;
			break;
		case 'f':
			showfila=(showfila+1)%2;
			break;
		case 'p':
			pause=(pause+1)%2;
			break;
		case 's':
			showpfn=(showpfn+1)%2;
			break;
		case 't':
			texturemap=(texturemap+1)%2;
			init_GL();
			display_list();
			break;
		case '0':
			testdirection=0;
			break;
		case '1':
			testdirection=1;
			break;
		case '2':
			testdirection=2;
			break;
		case '3':
			testdirection=3;
			break;
		case '4':
			testdirection=4;
			break;
		case 'c':
			linkcolor=(linkcolor+1)%2;
			break;
		case '+':
		case '=':
			zoom*=1.2f;
			zoominv=1.0f/zoom;
			updateGLboundary();
			break;
		case '-':
			zoom/=1.2f;
			zoominv=1.0f/zoom;
			updateGLboundary();
			break;
		case ' ':
			zoom=(float)((NtwkRadius/Rave)/CanvasFactor);
		#if TSTGEL
			zoom*=3.0f;
		#endif
			zoominv=1.0f/zoom;
			PanX=PanY=0.0f;
			#if TSTGEL
			PanY=-0.3f;
			#endif
			updateGLboundary();
			break;
		default:
			break;
	}
}


void arrow_keys(int a_keys, int x, int y)
{
	switch (a_keys) {
	case GLUT_KEY_UP:	// When Up Arrow Is Pressed...
		PanY-=0.1f;
		break;
	case GLUT_KEY_DOWN:	// When Down Arrow Is Pressed...
		PanY+=0.1f;
		break;
	case GLUT_KEY_RIGHT:
		PanX-=0.1f;
		break;
	case GLUT_KEY_LEFT:
		PanX+=0.1f;
		break;
	default:
		break;
  }
}


void mouse(int button, int state, int x, int y)
{
    if(button==GLUT_LEFT_BUTTON)
    {
        if(state==GLUT_DOWN) {
            mouse_left=1;
            mouse_x=x;
            mouse_y=y;
        }
        else mouse_left=0;
    }

	if(button==GLUT_RIGHT_BUTTON) {
        if(state==GLUT_DOWN) {
            mouse_right=1;
            mouse_x=x;
            mouse_y=y;
        }
        else mouse_right=0;
    }
}


void drag(int x, int y) 
{ 
	if(mouse_left==1) {
		PanX+=0.0025f*(x-mouse_x);
		PanY-=0.0025f*(y-mouse_y);
		mouse_x=x;
		mouse_y=y; 
		glutPostRedisplay(); 
	}

	if(mouse_right==1) {
		zoom*=(1.0f+0.005f*(x-mouse_x));
		zoom*=(1.0f-0.005f*(y-mouse_y));
		zoominv=1.0f/zoom;
		updateGLboundary();
		mouse_x=x;
		mouse_y=y; 
		glutPostRedisplay(); 
	} 
}

