

double getfilakdfactor(double dr)
{
	if(dr<0.0) return exp(-dr/dl_detach);
	else return 1.0;
}


void filadyna_i(graph_node *p)
{
	if(p->capped==1) return;

	if(p->attached==0) {	// free filaments
		p->sumka += kadt;
		p->sumkc += kcdt;
		
		if(p->sumkc > 1.0) {	// capped
			p->capped = 1;
			p->sumka = p->sumkc = p->sumkd = 0.0;
			if(Nfree>0) Nfree--;
		}
		else if(p->sumka > 1.0) {	// attach
			p->attached = 1;
			p->sumka = p->sumkc = p->sumkd = 0.0;
			Natt++;
			if(Nfree>0) Nfree--;
		}
	}
	else {	// attached filaments
		p->sumkd += getfilakdfactor(p->dlen)*kddt;
		if(p->sumkd > 1.0) {	// detached
			p->attached = 0;
			p->sumka = p->sumkc = p->sumkd = 0.0;
			Nfree++;
			if(Natt>0) Natt--;
		}
	}

}


void FilaDynamics(void)
{
	int i;
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		filadyna_i(p);
	}
}


void filadeform_i(graph_node *p)	// updates p->len0 & p->dlen
{
	p->len0 = distance(p->R0, p->R1);
	p->dlen = p->len - p->len0;	// spring deformation, dlen>0 compress for pushing
}


double getfilav(double dlen)	// given dlen, find filament growth v
{
	if(dlen<=0.0) return V0;
	else if(dlen<dl_buckle) {	// pushing
	#if EXPPWR
		return V0*exp(-dlen/dl0_scale);
	#else
		if(dlen<dl0_stall) return V0*(1.0-pow(dlen/dl0_stall,vfpower));
		else return 0.0;
	#endif
	}
	else return 0.0;	// buckled
}


void filagrowth_i(graph_node *p)
{
	double v, nr[2];
	
	filadeform_i(p);	// updates p->len0 & p->dlen
	
	v=getfilav(p->dlen);
	p->len += v*dt;
	//}
	p->dlen = p->len - p->len0;	// spring deformation, dlen>0 for pushing
	
	vecsub(p->R1, p->R0, nr);	// R0-R1 in lab, always perp to local surface
	vecprod(nr, (p->len)/max2(p->len0,dlt), p->Rtip);
	vecadd(p->Rtip, p->R0, p->Rtip);	// get Rtip
}


void FilaGrowth(void)	// update p->len and p->dlen
{
	int i;
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		veczero(p->ftip);
		veczero(p->Ftip);
		if(p->contact) {
			if(p->attached==0 && p->capped==0) filagrowth_i(p);
		}
	}
}


/*-------------------------------------
	filament deform
-------------------------------------*/

void FilaDeform(void)	// update all p->dlen, after gel move
{
	int i;
	graph_node *p;
	
	for(i=0; i<Nnodes; i++) {
		p=graph[i];
		if(p->contact) filadeform_i(p);
	}
}

