function [Front, status] = PropogateFront(FrontierPointer, time, Front, ExactPolygon, Domain, MeshSize)

if isempty(ExactPolygon) 
  
    % Get the next front
    step.command = 'step';
    step.front = FrontierPointer;
    step.timeStop = time;
    [~, Front.Polygon ] = fronTierCmd(step);  

    MyCurve = Front.Polygon(:,1)>Domain{1}(1) & Front.Polygon(:,1)<Domain{1}(2) & Front.Polygon(:,2)>Domain{2}(1) & Front.Polygon(:,2)<Domain{2}(2);
    Front.Polygon = Front.Polygon(MyCurve,:);
    Front.LevelSetFunction = [];
else
    Front.Polygon = [ExactPolygon{1}(time), ExactPolygon{2}(time)];
end

% check if front is hitting the outer box
status = false;
if min(Front.Polygon(:,1))<Domain{1}(1)+MeshSize || max(Front.Polygon(:,1))>Domain{1}(2)-MeshSize ||...
        min(Front.Polygon(:,2))<Domain{2}(1)+MeshSize || max(Front.Polygon(:,2))>Domain{2}(2)-MeshSize 
    disp('front extension exceeding the domain!')
    status = true;
end