function [FrontierPointer, Front] = InitializeFront(Front, ExactPolygon, Domain, N, T_max, FrontPropagate, FrontRedistMethod, FrontRedistFrequency)

if isempty(ExactPolygon) 
    % Initialize the level and velocity functions
    cmd.command = 'init';
    cmd.dim = 2;
    cmd.N = N;
    cmd.limits =  [Domain{1}(1) Domain{1}(2) Domain{2}(1) Domain{2}(2)];
    cmd.maxTime = T_max;
    
    switch FrontPropagate
      case 'first_order'
        cmd.propagate = 'first_order_point_propagate';
      case 'fourth_order'
        cmd.propagate = 'fourth_order_point_propagate';
    end
    
    switch FrontRedistMethod
      case 'DEFAULT'
        cmd.redistributionFrequency = FrontRedistFrequency;
      case 'EXPANSION_REDIST'
        cmd.redistribution =  FrontRedistMethod;
        cmd.redistributionFrequency = FrontRedistFrequency;
      case 'NO_REDIST'
        cmd.redistribution =  FrontRedistMethod;
    end

    f = fronTierCmd(cmd);

    % Get the initial front
    step.command = 'step';
    step.front = f;
    step.timeStop = 0.0;
    [~, Front.Polygon ] = fronTierCmd(step);
    FrontierPointer = f;

    MyCurve = Front.Polygon(:,1)>Domain{1}(1) & Front.Polygon(:,1)<Domain{1}(2) & Front.Polygon(:,2)>Domain{2}(1) & Front.Polygon(:,2)<Domain{2}(2);
    Front.Polygon = Front.Polygon(MyCurve,:);
    Front.LevelSetFunction = @(x,y,t) p_poly_dist_my(x,y,Front.Polygon(:,1), Front.Polygon(:,2));
else
    Front.Polygon = [ExactPolygon{1}(0), ExactPolygon{2}(0)];
    FrontierPointer = [];
end

