function [x_c, y_c, r_c, Area] = GetAreaCentroid(Front_All)

NumberFronts = size(Front_All,2);
x_c = zeros(NumberFronts,1);
y_c = zeros(NumberFronts,1);
r_c = zeros(NumberFronts,1);
Area = zeros(NumberFronts,1);

if NumberFronts == 1
  
  x = Front_All.Polygon(:,1);
  y = Front_All.Polygon(:,2);
  x0=x(1:end);x1=[x(2:end);x(1)];y0=y(1:end);y1=[y(2:end);y(1)];dx=x1-x0;dy=y1-y0;
  
  Area = sum(dy.*(x0+dx/2));
  x_c = sum(dy.*(x0.^2+1/3*dx.^2+x0.*dx))/(2*Area);
  y_c = -sum(dx.*(y0.^2+1/3*dy.^2+y0.*dy))/(2*Area);
  r_c = sqrt(x_c^2+y_c^2); 
  
else
  
  for i=1:NumberFronts
    x = Front_All{i}.Polygon(:,1);
    y = Front_All{i}.Polygon(:,2);
    x0=x(1:end);x1=[x(2:end);x(1)];y0=y(1:end);y1=[y(2:end);y(1)];dx=x1-x0;dy=y1-y0;

    Area(i) = sum(dy.*(x0+dx/2));
    x_c(i) = sum(dy.*(x0.^2+1/3*dx.^2+x0.*dx))/(2*Area(i));
    y_c(i) = -sum(dx.*(y0.^2+1/3*dy.^2+y0.*dy))/(2*Area(i));
    r_c(i) = sqrt(x_c(i)^2+y_c(i)^2);
  end  
  
end
