function vel = FT_velo_func(time, coords)

global M0 K V0 FM Actin_Velocity NormalX NormalY TotalArea DomainX DomainY A0 AreaExponent;

if coords(1)<DomainX(1) || coords(1)>DomainX(2) || coords(2)<DomainY(1) || coords(2)>DomainY(2)
    vel = zeros(1,2);
else
    M = FM(coords(1), coords(2));
    vp = V0/(M+M0)*(A0/TotalArea) - K*(TotalArea - A0*(A0/TotalArea)^AreaExponent);    
    v = Actin_Velocity(coords(1), coords(2));
    n = [NormalX(coords(1), coords(2)) NormalY(coords(1), coords(2))];
    vn = v*n';   
    vel = n*( vn + vp );
end
