function [RatioRadii] = AspectRatioMotileCell(FileName,v0,mu,alpha)

FontSize = 14;
SelectedTime = 'end';

% front info
[Front,~,~,x_c,y_c] = ExtractInitDomainShapeAR(FileName,SelectedTime,0,0,0);

% calculate the min and max radii and their ratio
X_f = Front.Polygon(:,1);
Y_f = Front.Polygon(:,2);

RadiiAll = sqrt ((X_f - x_c).^2 + (Y_f - y_c).^2 );
[minRadi, indexminRadi] = min(RadiiAll);
[maxRadi, indexmaxRadi] = max(RadiiAll);

RatioRadii = maxRadi/minRadi;
figure
plot(Front.Polygon(:,1),Front.Polygon(:,2),'.')
hold on
plot(x_c,y_c,'rx','markersize',10)

plot([x_c X_f(indexminRadi)],[y_c Y_f(indexminRadi)],'r-')
plot([x_c X_f(indexmaxRadi)],[y_c Y_f(indexmaxRadi)],'b-')

legend('Front','Centroid','Min (radius)','Max (radius)','location','northeastoutside')

title(['Ratio (max/min) = ' num2str(RatioRadii)],'FontSize',FontSize)
xlabel(['(v0,mu,alpha) = (' num2str(v0) ' , ' num2str(mu) ' , ' num2str(alpha) ' )'],'FontSize',FontSize)

set(gca,'FontSize',FontSize)
axis equal tight
end