function z = bilinear2D_vec(X, Y, Z_1,Z_2, InteriorMask, x, y, MeshSize)

X0 = X(InteriorMask);
Y0 = Y(InteriorMask);
dist = (X0 - x).^2 + (Y0 - y).^2;
[~, Idx] = min(dist);

X0 = X0(Idx);
Y0 = Y0(Idx);
SignX = sign(x - X0);
SignY = sign(y - Y0);

if (SignX ~= 0) && (SignY ~=0)
  X0 = X0 + MeshSize*sign(x - X0)*[0 0 1 1] ;
  Y0 = Y0 + MeshSize*sign(y - Y0)*[0 1 1 0] ;

  x1 = min(X0);
  y1 = min(Y0);
  x2 = max(X0);
  y2 = max(Y0);

  ind11=abs(X - x1) < 1e-10 & abs(Y - y1) < 1e-10;
  ind12=abs(X - x1) < 1e-10 & abs(Y - y2) < 1e-10;
  ind21=abs(X - x2) < 1e-10 & abs(Y - y1) < 1e-10;
  ind22=abs(X - x2) < 1e-10 & abs(Y - y2) < 1e-10;

  Q11 = Z_1(ind11);
  Q12 = Z_1(ind12);
  Q21 = Z_1(ind21);
  Q22 = Z_1(ind22);

  % First component
  z_1 = 1/(x2-x1)/(y2-y1)*(Q11*(x2-x).*(y2-y) - Q12*(x2-x).*(y1-y) - Q21*(x1-x).*(y2-y) + Q22*(x1-x).*(y1-y));

  Q11 = Z_2(ind11);
  Q12 = Z_2(ind12);
  Q21 = Z_2(ind21);
  Q22 = Z_2(ind22);

  % Second component
  z_2 = 1/(x2-x1)/(y2-y1)*(Q11*(x2-x).*(y2-y) - Q12*(x2-x).*(y1-y) - Q21*(x1-x).*(y2-y) + Q22*(x1-x).*(y1-y));

  z=[z_1 z_2];
  return;
end

if (SignX == 0) && (SignY ==0)
  z = [Z_1(abs(X - X0) < 1e-10 & abs(Y - Y0) < 1e-10) Z_2(abs(X - X0) < 1e-10 & abs(Y - Y0) < 1e-10)];
  return;
end

if  SignX == 0
  X1 = X0;
  Y1 = Y0 + MeshSize*sign(y - Y0);
  
  ind0 = abs(X - X0) < 1e-10 & abs(Y - Y0) < 1e-10;
  ind1 = abs(X - X1) < 1e-10 & abs(Y - Y1) < 1e-10;
  
  Q0 = Z_1(ind0);
  Q1 = Z_1(ind1);
  z_1 = Q0 + (Q1-Q0)/(Y1-Y0)*(y-Y0);
  
  Q0 = Z_2(ind0);
  Q1 = Z_2(ind1);
  z_2 = Q0 + (Q1-Q0)/(Y1-Y0)*(y-Y0);  
  
  z=[z_1 z_2];
  return;
end

if  SignY == 0
  Y1 = Y0;
  X1 = X0 + MeshSize*sign(x - X0);
  
  ind0 = abs(X - X0) < 1e-10 & abs(Y - Y0) < 1e-10;
  ind1 = abs(X - X1) < 1e-10 & abs(Y - Y1) < 1e-10;
  
  Q0 = Z_1(ind0);
  Q1 = Z_1(ind1);
  z_1 = Q0 + (Q1-Q0)/(X1-X0)*(x-X0);
  
  Q0 = Z_2(ind0);
  Q1 = Z_2(ind1);
  z_2 = Q0 + (Q1-Q0)/(X1-X0)*(x-X0);  
  
  z=[z_1 z_2];
  return;
end


