function z = bilinear2D(X, Y, Z, InteriorMask, x, y, MeshSize)
%%
X0 = X(InteriorMask);
Y0 = Y(InteriorMask);
dist = (X0 - x).^2 + (Y0 - y).^2;
[~, Idx] = min(dist);

X0 = X0(Idx);
Y0 = Y0(Idx);
SignX = sign(x - X0);
SignY = sign(y - Y0);

if (SignX ~= 0) && (SignY ~=0)
 
  X0 = X0 + MeshSize*sign(x - X0)*[0 0 1 1] ;
  Y0 = Y0 + MeshSize*sign(y - Y0)*[0 1 1 0] ;

  x1 = min(X0);
  y1 = min(Y0);
  x2 = max(X0);
  y2 = max(Y0);

  Q11 = Z(abs(X - x1) < 1e-10 & abs(Y - y1) < 1e-10);
  Q12 = Z(abs(X - x1) < 1e-10 & abs(Y - y2) < 1e-10);
  Q21 = Z(abs(X - x2) < 1e-10 & abs(Y - y1) < 1e-10);
  Q22 = Z(abs(X - x2) < 1e-10 & abs(Y - y2) < 1e-10);

  z = 1/(x2-x1)/(y2-y1)*(Q11*(x2-x).*(y2-y) - Q12*(x2-x).*(y1-y) - Q21*(x1-x).*(y2-y) + Q22*(x1-x).*(y1-y));
  return;
end

if (SignX == 0) && (SignY ==0)
  z = Z(abs(X - X0) < 1e-10 & abs(Y - Y0) < 1e-10);
  return;
end

if  SignX == 0
  X1 = X0;
  Y1 = Y0 + MeshSize*sign(y - Y0);
  
  Q0 = Z(abs(X - X0) < 1e-10 & abs(Y - Y0) < 1e-10);
  Q1 = Z(abs(X - X1) < 1e-10 & abs(Y - Y1) < 1e-10);
  
  z = Q0 + (Q1-Q0)/(Y1-Y0)*(y-Y0);
  return;
end

if  SignY == 0
  Y1 = Y0;
  X1 = X0 + MeshSize*sign(x - X0);
  
  Q0 = Z(abs(X - X0) < 1e-10 & abs(Y - Y0) < 1e-10);
  Q1 = Z(abs(X - X1) < 1e-10 & abs(Y - Y1) < 1e-10);
  
  z = Q0 + (Q1-Q0)/(X1-X0)*(x-X0);
  return;
end




