function [mat,RHS] = TransientTerm(A, A_old, Sol, RankineHugoniot, NumInsideNodes)

% returns the matrix 'mat' and the 'RHS' vector of the transient term. For
% explicit TS it returns the RHS only.
% Please note that A_old should be used to build RHS for 'Rankine-Hugoniot'
% BC, and 'A' for Dirichlet BCs.

% Check the time discretization scheme
if nargin>4    % implicit TS assembles the coeff matrix 'mat' (LHS) and the RHS vector
  mat = sparse(1:NumInsideNodes, 1:NumInsideNodes, A , NumInsideNodes, NumInsideNodes);
  if RankineHugoniot
    RHS = Sol.*A_old;
  else
    RHS = Sol.*A;
  end
else            % explicit TS assembles the 'vector = mat*sol' (RHS)
  mat = [];
  if RankineHugoniot
    RHS = Sol.*A_old;
  else
    RHS = Sol.*A;
  end
end

end  % end of function 'TransientTerm'