function vel = FT_velo_func(time, coords)

global M0 K V0 FM NormalX NormalY TotalArea DomainX DomainY AreaExponent A0;

if coords(1)<DomainX(1) || coords(1)>DomainX(2) || coords(2)<DomainY(1) || coords(2)>DomainY(2)
    vel = zeros(1,2);
else
    M = FM(coords(1), coords(2));
    v = V0/(M+M0)*(A0/TotalArea) - K*(TotalArea - A0*(A0/TotalArea)^AreaExponent);
    n = [NormalX(coords(1), coords(2)) NormalY(coords(1), coords(2))];
    vel = n*v;
end 