function [InitFront,id_Front,InitArea,x_c,y_c] = ExtractInitDomainShape(FileNameInitShape,SelectedTime,NormalizeToCentroid,FlipVertically,FlipHorizontally)

% load data file
load(FileNameInitShape,'Front_All','Time_All')

if SelectedTime>max(Time_All)
  disp('Selected time for domain initialization is greater than the end time!');
  return;
end

% find the front index corresponding (closest) to t = SelectedTime
if length(Time_All) > 1
  dt = Time_All(2)-Time_All(1);
  id_Front = find(abs(Time_All-SelectedTime) < 0.5*dt, 1 );
else
  id_Front = 1;
end

% read the front and get the initial area, and coordinates of its centroid
InitFront.Polygon = [Front_All{id_Front}.Polygon(:,1) Front_All{id_Front}.Polygon(:,2)];
[x_c, y_c, ~,InitArea] = GetAreaCentroid(InitFront);

if NormalizeToCentroid
  % re-normalize the coordinates so that the centroid of the cell is
  % always at (0,0)
  InitFront.Polygon(:,1) = InitFront.Polygon(:,1) - x_c;
  InitFront.Polygon(:,2) = InitFront.Polygon(:,2) - y_c;
  
  if FlipHorizontally
    InitFront.Polygon(:,2) = -InitFront.Polygon(:,2);
  end

  if FlipVertically
    InitFront.Polygon(:,1) = -InitFront.Polygon(:,1);
  end
  
else
  
  if FlipHorizontally
    InitFront.Polygon(:,2) = 2*y_c-InitFront.Polygon(:,2);
  end

  if FlipVertically
    InitFront.Polygon(:,1) = 2*x_c-InitFront.Polygon(:,1);
  end
   
end

clear Front_All Time_All

end