function CreateMovie(Sol_All, Ux_All, Uy_All, PosX, PosY, Time_All, Front_All, FileName, MeshSize,...
      v0,mu, alpha, SkipTimeFrames, FigurePosistion,XLIM,YLIM,FontSize,FontName,XTicks,YTicks,QuiverSpec)

h = figure('Position', FigurePosistion);

M = VideoWriter([FileName '.avi']);
M.FrameRate = 10; 
MLimits = [median(min(Sol_All)) median(max(Sol_All))];
maxV = median(max(sqrt(Ux_All.^2+Uy_All.^2)));
if maxV<0.01
    maxV = max(max(sqrt(Ux_All.^2+Uy_All.^2)));
end

hold on;

open(M);
skip = SkipTimeFrames;
for iT = 1:skip:length(Time_All)
    VisualizeSolution(Sol_All(:,iT), PosX, PosY, MeshSize, Time_All(iT), Front_All{iT}, 0, 0);
    hold on;
    if iT == 1
        caxis(MLimits);
        colorbar('FontSize', FontSize);
        colormap jet
    end
    imaxV = max(sqrt(Ux_All(:,iT).^2+Uy_All(:,iT).^2));
    VisualizeSolution({Ux_All(:,iT), Uy_All(:,iT), min([2 imaxV/maxV])}, PosX, PosY, MeshSize, Time_All(iT), Front_All{iT}, 1, 0,QuiverSpec);
    text(XLIM(1)+0.5, YLIM(2)*0.8, ['t = ' num2str(Time_All(iT),'%4.1f')], 'FontSize', FontSize ,'Color', 'k','FontName',FontName)
    title(['v_0 = ' num2str(v0) '  , \mu_{tot} = ' num2str(mu) '  , \alpha = ' num2str(alpha)], 'FontSize', FontSize,'FontName',FontName);
    axis equal
    xlim(XLIM);
    ylim(YLIM);
    set(gca,'xtick',XTicks)
    set(gca,'ytick',YTicks)
    set(gca,'FontSize',FontSize,'FontName',FontName)
    hold off
    frame = getframe(h);
    writeVideo(M,frame);
end
close(M)
